#ifndef SEARCHOPTIONSDIALOG_H
#define SEARCHOPTIONSDIALOG_H

#include "abstractdialog.h"
#include "settings.h"
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QScrollArea>
#include <QGridLayout>

class SearchOptionsDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit SearchOptionsDialog(Settings *settings, QWidget *parent = 0);

private slots:
    void saveSettings();
    
private:
    void loadSettings();
    void setLandscapeLayout();
    void setPortraitLayout();

private:
    Settings *m_settings;
    QCheckBox *m_serviceCheckbox;
    QCheckBox *m_typeCheckbox;
    QCheckBox *m_orderCheckbox;
    QCheckBox *m_timeCheckbox;
    QCheckBox *m_durationCheckbox;
    QCheckBox *m_languageCheckbox;
    QDialogButtonBox *m_buttonBox;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // SEARCHOPTIONSDIALOG_H
