#include "playlistitem.h"
#include "utils.h"

PlaylistItem::PlaylistItem(const QVariantMap &playlist, QObject *parent) :
    QObject(parent),
    m_id(playlist.value("id").toString()),
    m_playlistId(id()),
    m_title(playlist.value("name").toString()),
    m_artist(playlist.value("owner.username").toString()),
    m_artistId(playlist.value("owner.id").toString()),
    m_artistAvatarUrl(playlist.value("owner.avatar_medium_url").toString()),
    m_description(playlist.value("description").toString()),
    m_duration(0),
    m_date(Utils::dateFromSecs(playlist.value("created_time").toLongLong())),
    m_videoCount(0)
{
}

PlaylistItem::PlaylistItem(const QDomNode &playlist, QObject *parent) :
    QObject(parent),
    m_id(playlist.firstChildElement("id").text()),
    m_playlistId(playlist.firstChildElement("yt:playlistId").text()),
    m_title(playlist.firstChildElement("title").text()),
    m_artist(playlist.firstChildElement("author").firstChildElement("name").text()),
    m_artistId(playlist.firstChildElement("author").firstChildElement("yt:userId").text()),
    m_artistAvatarUrl("http://i2.ytimg.com/i/" + artistId() + "/1.jpg"),
    m_description(playlist.firstChildElement("summary").text()),
    m_duration(0),
    m_date(Utils::localDateTimeFromString(playlist.firstChildElement("published").text())),
    m_thumbnailUrl(playlist.firstChildElement("media:group").firstChildElement("media:thumbnail").attribute("url")),
    m_videoCount(playlist.firstChildElement("yt:countHint").text().toInt())
{
}
