#ifndef COOKIEJAR_H
#define COOKIEJAR_H

#include <QNetworkCookieJar>

class CookieJar : public QNetworkCookieJar
{
    Q_OBJECT

public:
    enum Mode {
        PlaybackMode = 0,
        DownloadMode
    };

public:
    explicit CookieJar(CookieJar::Mode mode = CookieJar::DownloadMode, QObject *parent = 0);
    ~CookieJar() {}
    bool youtubeCookiesSet() const;
    bool dailymotionCookiesSet() const;
    QList<QNetworkCookie> cookiesForUrl(const QUrl &url) const;

public slots:
    void setYouTubeCookies(const QByteArray &rawCookie);
    void setYouTubeCookies();
    void setDailymotionCookies(const QByteArray &rawCookie);
    void setDailymotionCookies();
    void storeYouTubeCookies();
    void storeDailymotionCookies();
    void clearYouTubeCookies();
    void clearYouTubeCookiesFromDB(bool displayAlert = false);
    void clearDailymotionCookies();
    void clearDailymotionCookiesFromDB(bool displayAlert = false);
    void clearTwitterCookies();

signals:
    void alert(const QString &message);
    void gotYouTubeCookies(const QByteArray &cookieString);
    void gotDailymotionCookies(const QByteArray &cookieString);

private:
    CookieJar::Mode m_mode;
    QList<QNetworkCookie> m_dailymotionCookies;
    QList<QNetworkCookie> m_youtubeCookies;
};

#endif // COOKIEJAR_H
