#ifndef ABSTRACTUSERLISTMODEL_H
#define ABSTRACTUSERLISTMODEL_H

#include "thumbnailcache.h"
#include "useritem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class AbstractUserListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        SubscriptionIdRole,
        UsernameRole,
        ChannelNameRole,
        AvatarRole,
        VideoCountRole,
        DescriptionRole,
        ViewCountRole,
        SubscriberCountRole,
        SubscriptionRole
    };

public:
    explicit AbstractUserListModel(ThumbnailCache *cache, QObject *parent = 0);
    ~AbstractUserListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QSharedPointer<UserItem> get(int row) const;
    void insertUser(int row, QSharedPointer<UserItem> user);
    void appendUser(QSharedPointer<UserItem> user);
    bool removeUser(const QString &id);
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();

protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<UserItem> > m_list;
};

#endif // ABSTRACTUSERLISTMODEL_H
