#include "youtubeuserplaylistlistmodel.h"

YouTubeUserPlaylistListModel::YouTubeUserPlaylistListModel(Session *session, QObject *parent) :
    QAbstractListModel(parent),
    m_session(session),
    m_cache(m_session->newThumbnailCache())
{
    if (!m_session->youtube()->playlistsLoaded()) {
        m_session->youtube()->getPlaylists();
    }

    connect(m_session->youtube(), SIGNAL(playlistAddedToCache(int)), this, SLOT(onPlaylistAdded(int)));
    connect(m_session->youtube(), SIGNAL(playlistRemovedFromCache(int)), this, SLOT(onPlaylistRemoved(int)));
    connect(m_session->youtube(), SIGNAL(playlistUpdated(int)), this, SLOT(onPlaylistUpdated(int)));
    connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
}

YouTubeUserPlaylistListModel::~YouTubeUserPlaylistListModel() {
    delete m_cache;
}

void YouTubeUserPlaylistListModel::onPlaylistAdded(int row) {
    beginInsertRows(QModelIndex(), row, row);
    endInsertRows();
}

void YouTubeUserPlaylistListModel::onPlaylistRemoved(int row) {
    beginRemoveRows(QModelIndex(), row, row);
    endRemoveRows();
}

void YouTubeUserPlaylistListModel::onPlaylistUpdated(int row) {
    emit dataChanged(index(row), index(row));
}

int YouTubeUserPlaylistListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);
    return m_session->youtube()->playlists()->size();
}

QVariant YouTubeUserPlaylistListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_session->youtube()->playlists()->at(index.row()).data()->id();
    case PlaylistIdRole:
        return m_session->youtube()->playlists()->at(index.row()).data()->playlistId();
    case TitleRole:
        return m_session->youtube()->playlists()->at(index.row()).data()->title();
    case ArtistRole:
        return m_session->youtube()->playlists()->at(index.row()).data()->artist();
    case DateRole:
        return m_session->youtube()->playlists()->at(index.row()).data()->date();
    case VideoCountRole:
        return m_session->youtube()->playlists()->at(index.row()).data()->videoCount();
    case ThumbnailRole:
        return m_cache->thumbnail(m_session->youtube()->playlists()->at(index.row()).data()->thumbnailUrl(), QSize(120, 90));
    case DescriptionRole:
        return m_session->youtube()->playlists()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

void YouTubeUserPlaylistListModel::onThumbnailReady() {
    emit dataChanged(index(0), index(rowCount() - 1));
}
