#ifndef YOUTUBEUSERLISTMODEL_H
#define YOUTUBEUSERLISTMODEL_H

#include "abstractuserlistmodel.h"
#include "session.h"

class YouTubeUserListModel : public AbstractUserListModel
{
    Q_OBJECT

public:
    explicit YouTubeUserListModel(Session *session, QObject *parent = 0);
    inline QString feed() const { return m_feed; }
    void setFeed(const QString &afeed);
    inline bool loading() const { return m_loading; }

public slots:
    void getUsers(const QString &afeed = QString());
    void search(const QString &query = QString());
    void getMoreUsers();

private slots:
    void addUsers();
    inline void onError() { setError(true); setLoading(false); }

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(); }
    inline QString query() const { return m_query; }
    inline void setQuery(const QString &query) { m_query = query; }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged();

private:
    Session *m_session;
    QString m_feed;
    QString m_query;
    bool m_subscriptions;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // YOUTUBEUSERLISTMODEL_H
