#include "youtubesubscriptionlistmodel.h"

YouTubeSubscriptionListModel::YouTubeSubscriptionListModel(Session *session, QObject *parent) :
    QAbstractListModel(parent),
    m_session(session),
    m_cache(m_session->newThumbnailCache())
{
    if (!m_session->youtube()->subscriptionsLoaded()) {
        m_session->youtube()->getSubscriptions();
    }

    connect(m_session->youtube(), SIGNAL(subscriptionAddedToCache(int)), this, SLOT(onSubscriptionAdded(int)));
    connect(m_session->youtube(), SIGNAL(subscriptionRemovedFromCache(int)), this, SLOT(onSubscriptionRemoved(int)));
    connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
}

YouTubeSubscriptionListModel::~YouTubeSubscriptionListModel() {
    delete m_cache;
}

void YouTubeSubscriptionListModel::onSubscriptionAdded(int row) {
    beginInsertRows(QModelIndex(), row, row);
    endInsertRows();
}

void YouTubeSubscriptionListModel::onSubscriptionRemoved(int row) {
    beginRemoveRows(QModelIndex(), row, row);
    endRemoveRows();
}

int YouTubeSubscriptionListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);
    return m_session->youtube()->subscriptions()->size();
}

QVariant YouTubeSubscriptionListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_session->youtube()->subscriptions()->at(index.row()).data()->id();
    case SubscriptionIdRole:
        return m_session->youtube()->subscriptions()->at(index.row()).data()->subscriptionId();
    case UsernameRole:
        return m_session->youtube()->subscriptions()->at(index.row()).data()->username();
    case ChannelNameRole:
        return m_session->youtube()->subscriptions()->at(index.row()).data()->channelName();
    case AvatarRole:
        return m_cache->thumbnail(m_session->youtube()->subscriptions()->at(index.row()).data()->avatarUrl(), QSize(60, 60));
    case VideoCountRole:
        return m_session->youtube()->subscriptions()->at(index.row()).data()->videoCount();
    case SubscriberCountRole:
        return m_session->youtube()->subscriptions()->at(index.row()).data()->subscriberCount();
    case SubscriptionRole:
        return m_session->youtube()->subscriptions()->at(index.row()).data()->subscription();
    default:
        return QVariant();
    }
}

void YouTubeSubscriptionListModel::onThumbnailReady() {
    emit dataChanged(index(0), index(rowCount() - 1));
}
