#include "youtubecategorymodel.h"
#include "feedurls.h"

YouTubeCategoryModel::YouTubeCategoryModel(QObject *parent) :
    SelectionModel(parent)
{
    setTextAlignment(Qt::AlignLeft);

    m_time_filters[Queries::AllTime] = "all_time";
    m_time_filters[Queries::ThisWeek] = "this_week";
    m_time_filters[Queries::ThisMonth] = "this_month";

    addItem(tr("Cars & Vehicles"), feedFromValues("Autos"));
    addItem(tr("Comedy"), feedFromValues("Comedy"));
    addItem(tr("Education"), feedFromValues("Education"));
    addItem(tr("Entertainment"), feedFromValues("Entertainment"));
    addItem(tr("Film"), feedFromValues("Film"));
    addItem(tr("Gaming"), feedFromValues("Games"));
    addItem(tr("Most Discussed"), feedFromValues("most_discussed", true, Queries::AllTime));
    addItem(tr("Most Discussed (Today)"), feedFromValues("most_discussed", true, Queries::Today));
    addItem(tr("Most Discussed (This Week)"), feedFromValues("most_discussed", true, Queries::ThisWeek));
    addItem(tr("Most Discussed (This Month)"), feedFromValues("most_discussed", true, Queries::ThisMonth));
    addItem(tr("Most Popular"), feedFromValues("most_viewed", true, Queries::AllTime));
    addItem(tr("Most Popular (Today)"), feedFromValues("most_popular", true, Queries::Today));
    addItem(tr("Most Popular (This Week)"), feedFromValues("most_popular", true, Queries::ThisWeek));
    addItem(tr("Most Popular (This Month)"), feedFromValues("most_popular", true, Queries::ThisMonth));
    addItem(tr("Most Recent"), feedFromValues("most_recent", true));
    addItem(tr("Most Responded"), feedFromValues("most_responded", true, Queries::AllTime));
    addItem(tr("Most Responded (Today)"), feedFromValues("most_responded", true, Queries::Today));
    addItem(tr("Most Responded (This Week)"), feedFromValues("most_responded", true, Queries::ThisWeek));
    addItem(tr("Most Responded (This Month)"), feedFromValues("most_responded", true, Queries::ThisMonth));
    addItem(tr("Most Shared"), feedFromValues("most_shared", true));
    addItem(tr("Music"), feedFromValues("Music"));
    addItem(tr("News & Politics"), feedFromValues("News"));
    addItem(tr("Non-profits & Activism"), feedFromValues("Nonprofit"));
    addItem(tr("People"), feedFromValues("People"));
    addItem(tr("Pets & Animals"), feedFromValues("Animals"));
    addItem(tr("Recently Featured"), feedFromValues("recently_featured", true));
    addItem(tr("Science & Technology"), feedFromValues("Tech"));
    addItem(tr("Sport"), feedFromValues("Sports"));
    addItem(tr("Style"), feedFromValues("Howto"));
    addItem(tr("Top Favourites"), feedFromValues("top_favorites", true, Queries::AllTime));
    addItem(tr("Top Favourites (Today)"), feedFromValues("top_favorites", true, Queries::Today));
    addItem(tr("Top Favourites (This Week)"), feedFromValues("top_favorites", true, Queries::ThisWeek));
    addItem(tr("Top Favourites (This Month)"), feedFromValues("top_favorites", true, Queries::ThisMonth));
    addItem(tr("Top Rated"), feedFromValues("top_rated", true, Queries::AllTime));
    addItem(tr("Top Rated (Today)"), feedFromValues("top_rated", true, Queries::Today));
    addItem(tr("Top Rated (This Week)"), feedFromValues("top_rated", true, Queries::ThisWeek));
    addItem(tr("Top Rated (This Month)"), feedFromValues("top_rated", true, Queries::ThisMonth));
    addItem(tr("Travel & Events"), feedFromValues("Travel"));
    addItem(tr("Trending Videos"), feedFromValues("on_the_web", true));
}

QString YouTubeCategoryModel::feedFromValues(const QString &value, bool standard, Queries::TimeFilter time) {
    QString feed;

    if (standard) {
        feed = YOUTUBE_STANDARD_FEEDS_BASE_URL + QString("%1?v=2.1&max-results=30").arg(value);

        if (time != Queries::None) {
            feed.append(QString("&time=%1").arg(m_time_filters[time]));
        }
    }
    else {
        feed = YOUTUBE_VIDEOS_BASE_URL + QString("?v=2.1&max-results=30&orderby=published&category=%1").arg(value);
    }

    return feed;
}
