#include "xtubevideolistmodel.h"

XTubeVideoListModel::XTubeVideoListModel(Session *session, QObject *parent) :
    AbstractVideoListModel(session->newThumbnailCache(), parent),
    m_session(session)
{
    connect(m_session->xtube(), SIGNAL(gotVideos(QList< QSharedPointer<VideoItem> >)), this, SLOT(addVideos(QList< QSharedPointer<VideoItem> >)));
    connect(m_session->xtube(), SIGNAL(error(QString)), this, SLOT(onError()));
    connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
}

void XTubeVideoListModel::search(const QString &aquery, Services::VideoService aservice, Queries::QueryOrder anorder, Queries::TimeFilter atime, Queries::DurationFilter aduration) {
    setLoading(true);

    if (!aquery.isEmpty()) {
        setQuery(aquery);
        setOffset(1);
        setService(aservice);
        setOrder(anorder);
        setTimeFilter(atime);
        setDurationFilter(aduration);
    }

    m_session->xtube()->search(service(), query(), offset(), order(), timeFilter(), durationFilter());
}

void XTubeVideoListModel::addVideos(QList< QSharedPointer<VideoItem> > videos) {
    if (videos.isEmpty()) {
        setMoreResults(false);
        setOffset(1);
    }
    else {
        setMoreResults(true);
        setOffset(offset() + 1);
    }

    while (!videos.isEmpty()) {
        appendVideo(videos.takeFirst());
    }

    setLoading(false);
}

void XTubeVideoListModel::getMoreVideos() {
    if ((moreResults()) && (!loading())) {
        search();
    }
}
