#ifndef DAILYMOTIONUSERLISTTAB_H
#define DAILYMOTIONUSERLISTTAB_H

#include "abstracttab.h"
#include "dailymotionuserlistmodel.h"
#include "listview.h"
#include <QLabel>
#include <QGridLayout>
#include <QAction>

class DailymotionUserListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionUserListTab(Session *session, const QString &userId, QWidget *parent = 0);
    void setFeed(const QString &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);
    void showUserChannel(const QString &userId);
    void showSubscriptionVideos();

private:
    Session *m_session;
    QString m_userId;
    DailymotionUserListModel *m_model;
    ListView *m_listView;
    QAction *m_videosAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONUSERLISTTAB_H
