#ifndef DAILYMOTIONGROUPLISTTAB_H
#define DAILYMOTIONGROUPLISTTAB_H

#include "abstracttab.h"
#include "../base/groupitem.h"

class ListView;
class DailymotionGroupListModel;
class QLabel;
class QGridLayout;
class QModelIndex;

class DailymotionGroupListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit DailymotionGroupListTab(QWidget *parent = 0);
    void setGroupFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);

private:
    ListView *m_listView;
    DailymotionGroupListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONGROUPLISTTAB_H
