#ifndef SOCIALVIDEOLISTMODEL_H
#define SOCIALVIDEOLISTMODEL_H

#include "videoitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class SocialVideoListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        VideoIdRole,
        FavouriteIdRole,
        PlaylistVideoIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        DurationRole,
        ViewCountRole,
        RatingCountRole,
        RatingRole,
#ifndef QML_USER_INTERFACE
        ThumbnailRole,
        ThumbnailPressedRole,
#endif
        ThumbnailUrlRole,
        ArchiveRole,
        ServiceRole,
        FavouriteRole,
        SelectedRole
    };

public:
    explicit SocialVideoListModel(QObject *parent = 0);
    ~SocialVideoListModel();
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    QSharedPointer<VideoItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE VideoItem* getFromQML(int row) const;
#endif
    Q_INVOKABLE QList<int> selectedRows() const { return m_selectedRows; }
    QList< QSharedPointer<VideoItem> > selectedItems() const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE QList<VideoItem*> selectedItemsFromQML() const;
#endif
    inline bool itemsSelected() const { return !this->selectedRows().isEmpty(); }

public slots:
    void selectAll();
    void selectNone();
    void toggleSelected(int row);
    void downloadSelectedVideos(bool saveAsAudio = false);
    void queueSelectedVideos();

private slots:
    void onVideoAdded(int row);
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif

signals:
    void countChanged(int count);
    void itemsSelectedChanged(bool selected);

private:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
    int m_thumbnailPressedRow;
#endif
    QList<int> m_selectedRows;
    QHash<int, QByteArray> m_roleNames;
};

#endif // SOCIALVIDEOLISTMODEL_H
