#include "vimeosubscriptionlistmodel.h"
#include "vimeo.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

VimeoSubscriptionListModel::VimeoSubscriptionListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    m_roleNames[IdRole] = "id";
    m_roleNames[SubscriptionIdRole] = "subscriptionId";
    m_roleNames[UsernameRole] = "username";
    m_roleNames[ChannelNameRole] = "channelName";
#ifndef QML_USER_INTERFACE
    m_roleNames[AvatarRole] = "avatar";
#endif
    m_roleNames[AvatarUrlRole] = "avatarUrl";
    m_roleNames[VideoCountRole] = "videoCount";
    m_roleNames[DescriptionRole] = "description";
    m_roleNames[ViewCountRole] = "viewCount";
    m_roleNames[SubscriberCountRole] = "subscriberCount";
    m_roleNames[SubscriptionRole] = "subscription";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!Vimeo::instance()->subscriptionsLoaded()) {
        Vimeo::instance()->getSubscriptions();
    }

    this->connect(Vimeo::instance(), SIGNAL(subscriptionAddedToCache(int)), this, SLOT(onSubscriptionAdded(int)));
    this->connect(Vimeo::instance(), SIGNAL(subscriptionRemovedFromCache(int)), this, SLOT(onSubscriptionRemoved(int)));
}

VimeoSubscriptionListModel::~VimeoSubscriptionListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> VimeoSubscriptionListModel::roleNames() const {
    return m_roleNames;
}
#endif

void VimeoSubscriptionListModel::onSubscriptionAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void VimeoSubscriptionListModel::onSubscriptionRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

int VimeoSubscriptionListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return Vimeo::instance()->subscriptions()->size();
}

QVariant VimeoSubscriptionListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->id();
    case SubscriptionIdRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->subscriptionId();
    case UsernameRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->username();
    case ChannelNameRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->channelName();
#ifndef QML_USER_INTERFACE
    case AvatarRole:
        return m_cache->thumbnail(Vimeo::instance()->subscriptions()->at(index.row()).data()->avatarUrl(), QSize(60, 60));
#endif
    case AvatarUrlRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->avatarUrl();
    case VideoCountRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->videoCount();
    case DescriptionRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->description();
    case ViewCountRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->viewCount();
    case SubscriberCountRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->subscriberCount();
    case SubscriptionRole:
        return Vimeo::instance()->subscriptions()->at(index.row()).data()->subscription();
    default:
        return QVariant();
    }
}

QVariant VimeoSubscriptionListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<UserItem> VimeoSubscriptionListModel::get(int row) const {
    return QSharedPointer<UserItem>(Vimeo::instance()->subscriptions()->at(row));
}

#ifdef QML_USER_INTERFACE
UserItem* VimeoSubscriptionListModel::getFromQML(int row) const {
    return Vimeo::instance()->subscriptions()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void VimeoSubscriptionListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
