#ifndef FILTERBOX_H
#define FILTERBOX_H

#include <QToolBar>
#include <QLineEdit>

class QAction;

class FilterBox : public QToolBar
{
    Q_OBJECT

public:
    explicit FilterBox(QWidget *parent = 0);
    inline QString filterText() const { return m_filterEdit->text(); }

public slots:
    inline void setFilterText(const QString &text) { m_filterEdit->setText(text); }
    void clear();

signals:
    void filterTextChanged(const QString &text);
    void cleared();
    
private:
    QLineEdit *m_filterEdit;
    QAction *m_cancelAction;
};

#endif // FILTERBOX_H
