#ifndef VIMEOAUTHDIALOG_H
#define VIMEOAUTHDIALOG_H

#include "abstractdialog.h"
#include <QUrl>

class WebView;
class QProgressBar;
class QGridLayout;

class VimeoAuthDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit VimeoAuthDialog(const QString &accountName, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { this->setFixedHeight(340); }
    inline void setPortraitLayout() { this->setFixedHeight(600); }

private slots:
    void setAuthUrl(const QUrl &url);
    void checkUrlForToken(const QUrl &url);

private:
    QString m_name;
    QUrl m_authUrl;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // VIMEOAUTHDIALOG_H
