#include "dbusadaptor.h"
#include <QtCore/QMetaObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QStringList>
#include <QtCore/QVariant>

/*
 * Implementation of adaptor class DBusAdaptor
 */

DBusAdaptor::DBusAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
    // constructor
    setAutoRelaySignals(true);
}

DBusAdaptor::~DBusAdaptor()
{
    // destructor
}

void DBusAdaptor::display(const QStringList &url)
{
    // handle method call com.maemo.cuteTube.display
    QMetaObject::invokeMethod(parent(), "display", Q_ARG(QStringList, url));
}

void DBusAdaptor::play(const QStringList &url)
{
    // handle method call com.maemo.cuteTube.play
    QMetaObject::invokeMethod(parent(), "play", Q_ARG(QStringList, url));
}

void DBusAdaptor::display(const QString &url)
{
    // handle method call com.maemo.cuteTube.display
    QMetaObject::invokeMethod(parent(), "display", Q_ARG(QString, url));
}

void DBusAdaptor::play(const QString &url)
{
    // handle method call com.maemo.cuteTube.play
    QMetaObject::invokeMethod(parent(), "play", Q_ARG(QString, url));
}

