#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Librarys
###########################################################################################
import sys, dbus, gtk, hildon
#from threading import Thread

#Files
###########################################################################################
from Config import Config
from Notifications import Notifications

#Classes
###########################################################################################
class Applet(gtk.Dialog):
	def __init__(self,parent = None):
		self.Config = Config()
		self.Notifications = Notifications()
		dialog = gtk.Dialog("Select trusted networks")
		dialog.connect("delete_event", self.quit)
		dialog.set_geometry_hints(min_height=800)
		help = dialog.add_button(gtk.STOCK_HELP, gtk.RESPONSE_NONE)
		help.connect('clicked', self.help)
		about = dialog.add_button("About", gtk.RESPONSE_NONE)
		about.connect('clicked', self.about)
		save = dialog.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
		save.connect('clicked', self.save)
		self.selector = hildon.TouchSelector(text = True)
		self.networks = self.Config.getAllNetworks()
		for network in self.networks:
			self.selector.append_text(network[1])
		self.selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE)
		dialog.vbox.add(self.selector)
		self.selector.unselect_all(0)
		for key, network in enumerate(self.networks):
			if network[2]:
				self.selector.select_iter(0, self.selector.get_model(0).get_iter(key), False);
		dialog.show_all()
		gtk.main()

	def save(self, ignore):
		selected = []
		networks = []
		for key, value in enumerate(self.selector.get_selected_rows(0)):
			selected.append(value[0]) 
		for key, network in enumerate(self.networks):
			if key in selected:
				networks.append([network[0], True])
			else:
				networks.append([network[0], False])
		self.Config.setTrustedNetworks(networks)
		self.Notifications.notify("Saved trusted networks")
		sys.exit(0)

	def about(self, ignore):
		dialog = gtk.AboutDialog()
		dialog.set_name("ConnLock")
		dialog.set_logo_icon_name("general_locked")
		dialog.set_authors(("Olli Laasonen [admin@laasonen.net]",""))
		dialog.set_documenters(("Olli Laasonen [admin@laasonen.net]",""))
		dialog.set_comments("Automatic device unlock based on current WLAN AP.")
		dialog.set_version("0.2.1")
		dialog.set_license("ConnLock\nCopyright (C) 2011  Olli Laasonen\n\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU Affero General Public License as\npublished by the Free Software Foundation, either version 3 of the\nLicense, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU Affero General Public License for more details.\n\nYou should have received a copy of the GNU Affero General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.")
		dialog.set_copyright("(c) Olli Laasonen")
		dialog.set_website("http://laasonen.net/")
		dialog.show()

	def help(self, ignore):
		dialog = gtk.Dialog("Help")
		text = gtk.Label()
		text.set_line_wrap(True)
		text.set_markup("<b>About</b>\nThis application opens your device without having to enter your password when you are connected to WLAN Access Point you trust.\n\n<b>Usage</b>\n1. Select WLAN Access Points you trust.\n2. Click Secure Device from power button menu.\n3. Your phone will unlock automaticly when you unlock the screen, if you are connected to one of the WLAN Access Points you trust.")

		dialog.vbox.add(text)
		dialog.show_all()

	def quit(self, ignore1, ignore2):
		gtk.main_quit()
#Run
###########################################################################################
if __name__ == "__main__":
	Applet()
