/*
 * Don Ceferino Hazaa - video game similary to Super Pang!
 * Copyright (c) 2004, 2005 Hugo Ruscitti
 * web site: http://www.loosersjuegos.com.ar
 * 
 * This file is part of Don Ceferino Hazaa (ceferino).
 * Written by Hugo Ruscitti <hugoruscitti@yahoo.com.ar>
 *
 * Don Ceferino Hazaa is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Don Ceferino Hazaa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */


#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <string.h>
#include "intro.h"
#include "mundo.h"
#include "grafico.h"
#include "utils.h"
#include "int.h"
#include "fuente2.h"

intro :: intro(void)
{
	paso=0;
	cambiar_etapa(PRESENTA);
}

intro :: ~intro(void)
{
	printf(_("+ Loading presentation: "));
	for (int i=0; i<6; i++)
		SDL_FreeSurface(imas[i]);

	SDL_FreeSurface(fondo);
	imprimir_ok();

	SDL_Delay(500);
}

/*!
 * \brief carga las pantalla de la animacin e inicia el objeto
 */
int intro :: iniciar(class mundo *_pmundo, int _modo_video, SDL_Surface *_screen)
{
	char base[200];
	char tmp[200];
	char nombres[8][200] = {\
		{"pres_losers.jpg"},\
		{"pres_sentado.jpg"},\
		{"pres_lee.jpg"},\
		{"pres_casa.jpg"},\
		{"pres_rapto.jpg"},\
		{"pres_vs.jpg"}};

	
	strcpy(base, DATADIR "/ima/");
	
	modo_video = _modo_video;
	
	printf(_("+ Loading intro: "));
	
	// carga todas las imagenes
	for (int i=0; i<6; i++)
	{
		printf(".");
		fflush(stdout);

		strcpy(tmp, base);
		strcat(tmp, nombres[i]);

		imas[i] = IMG_Load(tmp);
		
		if (imas[i] == NULL)
		{
			imprimir_error();
			printf(_("\t Can't load '%s' : '%s'\n"), tmp, SDL_GetError());
			return 1;
		}

		if (modo_video)
		{
			imas[i] = reescalar_mitad(imas[i]);

			if (imas[i] == NULL)
			{
				exit(1);
			}
		}

	}

	imprimir_ok();
	
	pmundo = _pmundo;
	screen = _screen;

	cambiar_etapa(PRESENTA);
	imprimir_etapa(etapa);

	fondo = SDL_DisplayFormat(screen);

	SDL_WarpMouse(1,1);

	return 0;
}

/*!
 * \brief actualizacin lgica
 */
void intro :: actualizar(int key_pressed)
{
	Uint8 *tecla;

	tecla = SDL_GetKeyState(NULL);


	/* avance automtico */
	if (etapa == PRESENTA && paso > 400)
	{
		avanzar_etapa ();
		paso = 0;
	}
	else if (paso > 500)
	{
		avanzar_etapa ();
		paso = 0;
	}

	/* avance con Space o Esc */
	if ( (paso > 40) && (tecla[SDLK_RETURN] || tecla[SDLK_KP_ENTER] ))
	{
		avanzar_etapa ();
		paso = 0;
	}
	
	paso ++;
	
	if (tecla[SDLK_q] || (key_pressed == TOUCH_SCREEN_PRESSED))
	{
		pmundo->cambiar_escena(MENU);
	}
}


/*!
 * \brief impresion programada desde mundo
 */
void intro :: imprimir(void)
{
	static int etapa_anterior = -1;

	if (etapa != etapa_anterior)
	{
		imprimir_etapa (etapa);
		etapa_anterior = etapa;
	}
}

/*!
 * \brief imprime un fondo de pantalla nuevo
 */
void intro :: imprimir_etapa(int etapa)
{
	SDL_BlitSurface(imas[etapa], NULL, screen, NULL);
	imprimir_texto ();
	SDL_Flip(screen);
}


void intro :: avanzar_etapa (void)
{
	if (etapa == VS)
	{
		Mix_FadeOutMusic(2000);
		pmundo->cambiar_escena(MENU);
	}
	else
	{
		etapa ++;
		cambiar_etapa(etapa);
	}
}

/*!
 * \brief altera la etapa actual cambiando textos y la imagen de fondo
 */
void intro :: cambiar_etapa(int etapa)
{
	pos=0;
	posx_letra=0;
	posy_letra=0;
	
	switch (etapa)
	{
		case PRESENTA:
//		strcpy(mensaje,_("  Touch the screen to skip intro"));
		break;

		case SENTADO:
		strcpy(mensaje,_("The cowboy Don Ceferino lived very happy in his quite and modest house in the countryside"));
		break;

		case LEE:
		strcpy(mensaje,_("but one day he read in the newspaper that aliens were adbucting all the cows around"));
		break;

		case ASOMBRO:
		strcpy(mensaje,_("with not exception. The aliens arrived at the farm of Don Ceferino..."));
		break;

		case RAPTO:
		strcpy(mensaje,_("and abducted his only cow."));
		break;

		case VS:
		strcpy(mensaje,_("But it didn't end here. Don Ceferino was determined to recover his precious cow."));
		break;
	}

	this->etapa = etapa;
}


void intro :: pausar(void)
{
}

void intro :: imprimir_texto (void)
{
	pmundo->fuente->myprintf_inferior (screen, NULL, NULL, false, mensaje);
}



