/*
 *  main.c - what's this?
 *
 *  Copyright (C) 1997-2004 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gtkimageview.h>
#ifdef USE_HILDON
#    include "hildon/hildon-window.h"
#    include <libosso.h>
#    include <gdk/gdkx.h>
#    include <X11/Xatom.h>
#endif
#include <getopt.h>
#include <string.h>

#include "interface2.h"
#include "support.h"
#include "global.h"
#include "conf.h"
#include "main.h"

#include "garchivereader.h"

GtkWidget *MainWindow;
GtkWidget *nav_window;
GtkWidget *nav_toolbar;
GtkWidget *fullscreen_item;
extern GtkImageView* book_canvas;

char	newbook[200] = "";


void
show_help(void)
{
  printf(_("\n------ .cbr/.cbz/.cb7 Pager %s ------\n"), prog_version);
  printf(_("(c) 2008 John Coppens and Benoit Goudreault-Emond\n\n"));
  printf(_("Usage:  cbrPager [options] [file]\n\n"));
  printf(_("  -d         Enables extra debugging messages\n"));
  printf(_("  -? (or -h) This help text\n"));
  printf(_("  file       File to show\n\n"));
  gtk_exit(0);
}

/* NOTE: the following are used to test ordering problems. */
static void
free_string(gpointer data, gpointer dummy)
{
  g_free(data);
}

static void
print_string(gpointer data, gpointer dummy)
{
  printf("%s\n", (const char*)data);
}

static void
test_sort(void)
{
  char buffer[255];
  GList* list = NULL;
  printf("Enter a bunch of strings, end with ^D:\n");
  while(fgets(buffer, 255, stdin)) {
    /* remove the newline at the end */
    char* ch = strrchr(buffer, '\n');
    if(ch)
      *ch = '\0';
    list = g_list_append(list, g_strdup(buffer));
  }
  /* try asciibetic */
  printf("\nASCII sort:\n");
  list = g_list_sort(list, g_archive_reader_translate_strategy(SORT_ASCII));
  g_list_foreach(list, print_string, NULL);
  
  /* try insensitive */
  printf("\nInsensitive sort:\n");
  list = g_list_sort(list, g_archive_reader_translate_strategy(SORT_CASE_INSENSITIVE));
  g_list_foreach(list, print_string, NULL);

  /* try natural */
  printf("\nNatural sort:\n");
  list = g_list_sort(list, g_archive_reader_translate_strategy(SORT_NATURAL));
  g_list_foreach(list, print_string, NULL);

  g_list_foreach(list, free_string, NULL);
  g_list_free(list);

  gtk_exit(0);
}

void
check_params(int argc, char *argv[])
{
  int i;

  while ((i = getopt (argc, argv, "dht?")) != EOF) {
    switch (i) {
      case 'd': debug = 1;
	break;
      case '?':
      case 'h':
        show_help();
        break;
      case 't':
	test_sort();
	break;
    }
  }

  // Process non-option argument(s)
  pref.explicit_file = FALSE;
  switch (argc - optind) {
    case 0: 		// no file specified
      break;
    case 1:		// exactly 1 filename
      strncpy(newbook, argv[optind], sizeof(newbook));
      pref.explicit_file = TRUE;
      break;
    default:
      show_help();
  }
}


int
main (int argc, char *argv[])
{
  GtkWidget* main_menu;

  /* initialize threading */
  g_thread_init(NULL);

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  check_params(argc, argv);

  gtk_set_locale();
  gtk_init(&argc, &argv);

  load_config();
  if (pref.explicit_file)
  {
      if(strcmp(pref.lastbook, newbook))
	  pref.pagenumber = 0;
      strncpy(pref.lastbook, newbook, sizeof(pref.lastbook));
  }

  MainWindow = create_MainWindow ();
  gtk_window_resize(GTK_WINDOW(MainWindow),
		pref.initwidth, pref.initheight);
  gtk_widget_show(MainWindow);

#ifdef USE_HILDON

  // Tell GTK we are handling the Zoom/Volume Keys
  const gulong zoom_volume_key_value = 1;
  gdk_property_change(  GTK_WIDGET(MainWindow)->window,
			gdk_atom_intern_static_string("_HILDON_ZOOM_KEY_ATOM"),
			gdk_x11_xatom_to_atom(XA_INTEGER),
			32,
			GDK_PROP_MODE_REPLACE,(guchar *)&zoom_volume_key_value,
			1);

  nav_toolbar = create_toolbar(MainWindow);
  main_menu = create_main_menu(&fullscreen_item);
  hildon_window_add_toolbar(HILDON_WINDOW(MainWindow),
			    GTK_TOOLBAR(nav_toolbar));
  hildon_window_set_menu(HILDON_WINDOW(MainWindow), GTK_MENU(main_menu));
  main_menu = create_help_popup();
  gtk_widget_show_all(main_menu);
  gtk_widget_tap_and_hold_setup(GTK_WIDGET(book_canvas), main_menu, NULL, 0);

  gtk_widget_show_all(nav_toolbar);
  nav_window = MainWindow; /* cheating! */
#else
  nav_window = create_nav_window ();
  gtk_window_set_decorated(GTK_WINDOW(nav_window), FALSE);
  gtk_window_set_transient_for(GTK_WINDOW(nav_window), 
		GTK_WINDOW(MainWindow));
  if (!pref.nav_hidden) 
    gtk_widget_show(nav_window);
  update_nav_position();
  install_timer();
#endif


  gtk_main();
  return 0;
}

