#include "importfilewindow.h"

ImportFileWindow::ImportFileWindow(const QStringList &list, QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_DeleteOnClose);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    QWidget *centralWidget = new QWidget();
    QVBoxLayout *lay = new QVBoxLayout(centralWidget);
    lay->setSpacing(8);
    lay->setContentsMargins(0, 0, 0, 0);
    QMaemo5EditBar *eb = new QMaemo5EditBar(tr("Choose items to import"));
    lay->addWidget(eb);
    QPushButton *pb = new QPushButton(tr("Import"));
    eb->addButton(pb);
    QPushButton *pball = new QPushButton(tr("Import All"));
    eb->addButton(pball);
    editlist = new QListWidget;
    editlist->addItems(list);
    editlist->setSelectionMode(QListWidget::MultiSelection);
    connect(pb, SIGNAL(clicked()), this, SLOT(addItems()));
    connect(pball, SIGNAL(clicked()), this, SLOT(addAll()));
    lay->addWidget(editlist);
    setCentralWidget(centralWidget);
    setWindowState(windowState() | Qt::WindowFullScreen);
}

ImportFileWindow::~ImportFileWindow()
{
}

void ImportFileWindow::addItems()
{
    QStringList selectedItems;
    for (int i = 0; i < editlist->count(); ++i) {
        if (editlist->item(i)->isSelected()){
            selectedItems.append(editlist->item(i)->text());
        }
    }
    if (selectedItems.isEmpty()){
        return;
    }
    else {
        int reply = QMessageBox::question(this, " ", tr("Add selected items?"), QMessageBox::Yes | QMessageBox::No, QMessageBox::No);
        if (reply == QMessageBox::Yes){
            emit returnList(selectedItems);
            close();
        }
    }
}

void ImportFileWindow::addAll()
{
    QStringList selectedItems;
    for (int i = 0; i < editlist->count(); ++i) {
        selectedItems.append(editlist->item(i)->text());
    }
    if (selectedItems.isEmpty()){
        return;
    }
    else {
        int reply = QMessageBox::question(this, " ", tr("Add selected items?"), QMessageBox::Yes | QMessageBox::No, QMessageBox::No);
        if (reply == QMessageBox::Yes){
            emit returnList(selectedItems);
            close();
        }
    }
}
