
"""The main class for the application"""
import gtk
import hildon
import os.path
import gobject          
import osso
import sys
import dbus
import location
import time
import locale
import gettext

import utils

APPNAME = 'caelia'
APPTITLE = 'Caelia'
APPVERSION = '0.0.1'
MAP_URL = """http://gmap-app.appspot.com/libellule?app=caelia\
&lat_src=%s&long_src=%s&lat_dest=%s&long_dest=%s"""
MEDIA_PATH = "/usr/share/qypy/"
GPS_ICON = "/usr/share/icons/hicolor/48x48/hildon/gps_location.png"
CLEAR_ICON = "/usr/share/icons/hicolor/48x48/hildon/general_stop.png"

gettext.install(APPNAME)

class  caeliaApp(hildon.Program):

    def __init__(self):
        """Contains main methods for the app class"""
        
        #Initializing GPS
        self.previousfixtime = float("nan")
        if not os.path.isfile('scratchbox'):
            self.latitude = None
            self.longitude = None
            self.control = location.GPSDControl.get_default()
            self.device = location.GPSDevice()
            self.device.reset_last_known()
            self.control.set_properties(
                                    preferred_method=location.METHOD_USER_SELECTED,
                                    preferred_interval=location.INTERVAL_DEFAULT)
            self.device.connect("changed", self.gps_on_changed, self.control)
            self.control.start()
        else:
            self.latitude = 48.10614
            self.longitude = -1.681467
        

        hildon.Program.__init__(self)
        self.window = hildon.StackableWindow()
        self.add_window(self.window)        
        self.window.set_title(APPTITLE)
        
        self.osso_c = osso.Context(APPNAME, "0.0.1", False)
        self.osso_r = osso.Rpc(self.osso_c)
        
        self.build_main_interface()
        self.all_stations = []
        try :
            self.all_stations = utils.get_all_stations()
        except Exception, err:
            self.warning_message(sys.exc_info()[0].__name__,  err)

        self.display_all_stations()

        self.menu = self.create_menu()
        self.window.set_app_menu(self.menu)
        
        self.window.show_all()
        self.window.connect("delete_event", self.quit, None)
        
        #self.nearbyme_places_window(None,  883)
        
        gtk.main()
        
        
    def build_main_interface(self):
        hbox = gtk.HBox(False, 0)
        self.search_entry = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.search_entry.set_placeholder(_('Station name'))
        hbox.pack_start(self.search_entry, True)
        self.search_entry.connect(
          "changed", self.filter_name_stations)
        clear_button = hildon.GtkButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        clear_button.set_image(gtk.image_new_from_file(CLEAR_ICON))
        clear_button.connect(
          "clicked", self.clear_search_entry)
        hbox.pack_start(clear_button, False)
        self.locate_button = hildon.GtkButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.locate_button.set_image(gtk.image_new_from_file(GPS_ICON))
        if not os.path.isfile('scratchbox'):
              self.locate_button.set_sensitive(False)
        self.locate_button.connect(
          "clicked", self.filter_geo_stations)

        hbox.pack_start(self.locate_button, False)

        vbox = gtk.VBox(False, 0)
        vbox.pack_start(hbox, False)
        parea = hildon.PannableArea()
        self.stations_treeview = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL)
        self.stations_treeview.eventid = None
        parea.add(self.stations_treeview)
        vbox.pack_start(parea, expand=True)

        self.stations_treeview.connect(  
                      "row-activated", self.view_gmap)

        self.store = gtk.ListStore(str, str, str, str)
        #Column 0 for the treeview
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("name", renderer, markup=0)
        column.set_property("expand", True)
        self.stations_treeview.append_column(column)
        self.stations_treeview.set_model(self.store)
        #Column 1 for the treeview
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("slots", renderer, markup=1)
        column.set_property("expand", True)
        self.stations_treeview.append_column(column)
        self.stations_treeview.set_model(self.store)

        self.window.add(vbox)


    def clear_search_entry(self, widget):
        self.search_entry.set_text("")
        self.display_all_stations()

 
    def display_all_stations(self):
        self.refresh_treeview(self.all_stations)     
        

    def filter_name_stations(self, widget):
        name = self.search_entry.get_text().upper()
        print "filter stations"
        all_stations = self.all_stations
        stations = []
        for station in all_stations:
            print name, station['name'].upper()
            print station['name'].upper().find(name.upper())
            if station['name'].upper().find(name.upper()) != -1:
                stations.append(station)
        print stations
     
        self.refresh_treeview(stations)


    def filter_geo_stations(self, widget):
        name = self.search_entry.get_text().upper()
        print "filter geo stations"
        stations = utils.get_geo_stations(self.latitude, self.longitude) 
        self.refresh_treeview(stations)


    def refresh_treeview(self, stations):
        self.store.clear()
        for station in stations:
            print station
            dst_str = ""
            if (str(self.device.fix[4]) != "nan") and (str(self.device.fix[5]) != "nan"):
                distance = location.distance_between(self.latitude, self.longitude,
                                            float(station['latitude']), 
                                            float(station['longitude']))
                
                if distance > 1:
                    dst_str = " - %.02f km" % distance
                else:
                    dst_str = " - %.0f m" % (distance*1000)
            name = "%s%s\n<small>%s</small>" % (
                                                station['name'], 
                                                dst_str,
                                                station['district'])

            slots = "%s: %s\n%s : %s" % (
                        _('Available bikes'), 
                        station['slotsavailable'],
                        _('Available slots'), 
                        station['bikesavailable'])
            self.store.append([name, slots, station['latitude'], station['longitude']])

              
    def button_clicked(self, widget, window, link):
        try:
            places_result = utils.get_places_from_url(link,  self.language)        
        except Exception, err:
            self.warning_message(sys.exc_info()[0].__name__,  err)
            return
        self.alter_places_window(None,  window, places_result)
        
        
    def quit(self,  control,  window,  widget):
        """Quit application"""
        gtk.main_quit()
        
        
    def warning_message(self,  exception, message):
        """"Display error dialog window"""
        
        if exception=='URLError':
            message = """Network error
            Check internet connection
            Or try later
            
            Internal error message :
            %s""" % message
        elif exception=='KeolisError':
            message = """Keolis error
            
            Internal error message :
            %s
            %s""" % (exception,  message)
        else:
            message = """Unknown error
            
            Internal error message :
            %s
            %s""" % (exception,  message)
        
        boite = gtk.Dialog("Error", self.window,
            gtk.DIALOG_MODAL,
            (gtk.STOCK_OK, gtk.RESPONSE_YES))
        msg_label = gtk.Label(message)
        msg_label.set_line_wrap(True)
        msg_label.set_size_request(-1, 300)
        boite.vbox.pack_start(msg_label, True, True, 0)
        boite.vbox.show_all()

        reponse = boite.run()
        boite.destroy()
        
        
    def gps_on_changed(self,  device,  user_data):
        """callback each time the location changes"""

        if device.fix:
            print self.previousfixtime,  device.fix[2]
            print str(device.fix[2])=='nan'
            if (str(device.fix[4]) != "nan") and (str(device.fix[5]) != "nan"):
                self.locate_button.set_sensitive(True)
                self.latitude = device.fix[4]
                self.longitude = device.fix[5]
                if not self.stations_treeview.eventid:
                    self.stations_treeview.eventid = self.stations_treeview.connect(  
                                                    "row-activated", self.view_gmap)
                self.locate_button.set_sensitive(True)
    

    def view_gmap(self, widget,  path,  view_column):
        station_latitude = self.store[path[0]][2]
        station_longitude = self.store[path[0]][3]
        url = MAP_URL % (self.latitude, self.longitude, station_latitude, station_longitude)
        print url
        self.osso_r.rpc_run('com.nokia.osso_browser', 
                            '/com/nokia/osso_browser/request', 
                            'com.nokia.osso_browser', 
                            'load_url', (url, ),
                            False, True) 
                            

    def create_menu(self):
        """Build the menu"""
    
        menu = hildon.AppMenu()
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        button.set_label("%s..." % _('About'))
        button.connect("clicked", self.display_about_dialog)
        menu.append(button)
        menu.show_all()
        return menu


    def display_about_dialog(self, widget):
        about_window = hildon.StackableWindow()    
        vbox = gtk.VBox(False, 0)
        label = gtk.Label()
        about_message = _('Caelia is an application for the Rennes city self-service hire scheme.')
        about_message = about_message + "\n\n<b>%s :</b> David Hautbois" % _('Developper')
        about_message = about_message + "\n<b>%s :</b> david.hautbois@free.fr" % _('Email')
        label.set_markup(about_message)
        vbox.pack_start(label, True, True, 0)
        about_window.add(vbox)  
        about_window.set_title(_('About Caelia'))
        about_window.show_all()
