/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QDateTime>

#include "unixtimebchwidget.h"

UnixTimeBchWidget::UnixTimeBchWidget(QWidget *parent) :
        ClockWidget(parent)
{
    layout = new QHBoxLayout(this);

    eighthNibble = new VerticalBinaryDisplayWidget(4, 0);
    addBinaryDisplayWidget(eighthNibble, layout);

    seventhNibble = new VerticalBinaryDisplayWidget(4, 0);
    addBinaryDisplayWidget(seventhNibble, layout);

    sixthNibble = new VerticalBinaryDisplayWidget(4, 0);
    addBinaryDisplayWidget(sixthNibble, layout);

    fifthNibble = new VerticalBinaryDisplayWidget(4, 0);
    addBinaryDisplayWidget(fifthNibble, layout);

    fourthNibble = new VerticalBinaryDisplayWidget(4, 0);
    addBinaryDisplayWidget(fourthNibble, layout);

    thirdNibble = new VerticalBinaryDisplayWidget(4, 0);
    addBinaryDisplayWidget(thirdNibble, layout);

    if(showSeconds){
        secondNibble = new VerticalBinaryDisplayWidget(4, 0);
        addBinaryDisplayWidget(secondNibble, layout);

        firstNibble = new VerticalBinaryDisplayWidget(4, 0);
        addBinaryDisplayWidget(firstNibble, layout);
    }else{
        secondNibble = NULL;
        firstNibble = NULL;
    }

    setFixedSize(sizeHint());
    layout->setSizeConstraint(QLayout::SetMinimumSize);

    updateTime();
}

UnixTimeBchWidget::~UnixTimeBchWidget(){
    if(firstNibble != NULL){
        delete firstNibble;
    }
    if(secondNibble != NULL){
        delete secondNibble;
    }

    delete thirdNibble;
    delete fourthNibble;
    delete fifthNibble;
    delete sixthNibble;
    delete seventhNibble;
    delete eighthNibble;

    delete layout;
}

QSize UnixTimeBchWidget::sizeHint(){
    QSize size((((showSeconds) ? 8 : 6) * (eighthNibble->getElementSize()))
                 + (((showSeconds) ? 7 : 5) * layout->spacing())
                 + (2 * layout->margin()),
                 (4 * eighthNibble->getElementSize())
                 + (2 * layout->margin()));

#ifdef Q_WS_MAEMO_5
    size.setHeight(size.height() + 10);
    size.setWidth(size.width() + 50);
#endif

    return size;
}

void UnixTimeBchWidget::updateTime(){
    uint time = QDateTime::currentDateTime().toUTC().toTime_t();

    if(firstNibble != NULL){
        firstNibble->updateValue(time & 0xF);
    }
    if(secondNibble != NULL){
        secondNibble->updateValue((time >> 4) & 0xF);
    }

    thirdNibble->updateValue((time >> 8) & 0xF);
    fourthNibble->updateValue((time >> 12) & 0xF);
    fifthNibble->updateValue((time >> 16) & 0xF);
    sixthNibble->updateValue((time >> 20) & 0xF);
    seventhNibble->updateValue((time >> 24) & 0xF);
    eighthNibble->updateValue((time >> 28) & 0xF);
}
