/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QSettings>

#include "clockwidget.h"
#include "settingsdialog.h"

ClockWidget::ClockWidget(QWidget *parent) :
    QWidget(parent)
{
    QSettings settings;
    showSeconds = settings.value(SettingsDialog::SHOW_SECONDS, SettingsDialog::SHOW_SECONDS_DEFAULT).toBool();

    timer = new QTimer();
    connect(timer, SIGNAL(timeout()), this, SLOT(updateTime()));
    timer->start(1000);
}

ClockWidget::~ClockWidget(){
    timer->stop();
    disconnect(timer, SIGNAL(timeout()), this, SLOT(updateTime()));
    delete timer;
}

void ClockWidget::addBinaryDisplayWidget(BinaryDisplayWidget *widget, QLayout *layout){
    connect(this, SIGNAL(settingsChanged()), widget, SLOT(applySettings()));
    layout->addWidget(widget);
}

void ClockWidget::applySettings(){
    emit settingsChanged();
}

void ClockWidget::resumeClock(bool resume){
    if(resume){
        updateTime();
        timer->start(1000);
    }else{
        timer->stop();
    }
}
