/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BCDCLOCKWIDGET_H
#define BCDCLOCKWIDGET_H

#include <QHBoxLayout>

#include "clockwidget.h"
#include "verticalbinarydisplaywidget.h"

class BcdClockWidget : public ClockWidget
{
    Q_OBJECT

public:
    explicit BcdClockWidget(QWidget *parent = 0);
    ~BcdClockWidget();

    QSize sizeHint();

protected slots:
    void updateTime();

private:
    QHBoxLayout *layout;

    VerticalBinaryDisplayWidget *secondsOneWidget;
    VerticalBinaryDisplayWidget *secondsTenWidget;
    VerticalBinaryDisplayWidget *minutesOneWidget;
    VerticalBinaryDisplayWidget *minutesTenWidget;
    VerticalBinaryDisplayWidget *hoursOneWidget;
    VerticalBinaryDisplayWidget *hoursTenWidget;

};

#endif // BCDCLOCKWIDGET_H
