/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QSettings>
#include <QStringList>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

const QString SettingsDialog::CLOCK_LED_COLOR = "clock_led_color";
const QColor SettingsDialog::CLOCK_LED_COLOR_DEFAULT = QColor(Qt::red);

const QString SettingsDialog::CLOCK_STYLE = "clock_style";
const int SettingsDialog::CLOCK_STYLE_DEFAULT = 0;

const QString SettingsDialog::LED_BORDER = "led_border";
const int SettingsDialog::LED_BORDER_DEFAULT = 8;

const QString SettingsDialog::LED_SIZE = "led_size";
const int SettingsDialog::LED_SIZE_DEFAULT = 34;

const QString SettingsDialog::SHOW_SECONDS = "show_seconds";
const bool SettingsDialog::SHOW_SECONDS_DEFAULT = true;

const QString SettingsDialog::USE_GRAY_CODE = "use_gray_code";
const bool SettingsDialog::USE_GRAY_CODE_DEFAULT = false;

#ifndef Q_WS_MAEMO_5
const QString SettingsDialog::POSITION = "position";
const QPoint SettingsDialog::POSITION_DEFAULT = QPoint(10, 10);

const QString SettingsDialog::TRANSPARENCY = "transparency";
const bool SettingsDialog::TRANSPARENCY_DEFAULT = true;

const QString SettingsDialog::WIDGET_PLACEMENT = "window_placement";
const int SettingsDialog::WIDGET_PLACEMENT_DEFAULT = 0;
#endif

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

    QStringList styles;
    styles.append(tr("Binary Clock"));
    styles.append(tr("BCD Clock"));
    styles.append(tr("Unix Time"));
    styles.append(tr("Unix Time \"BCH\""));

    QSettings settings;
    ui->clockStyleComboBox->addItems(styles);
    ui->clockStyleComboBox->setCurrentIndex(settings.value(SettingsDialog::CLOCK_STYLE,
                                                           SettingsDialog::CLOCK_STYLE_DEFAULT).toInt());
    ui->ledColorSelectionButton->setColor(settings.value(SettingsDialog::CLOCK_LED_COLOR,
                                          SettingsDialog::CLOCK_LED_COLOR_DEFAULT).value<QColor>());

    ui->ledBorderSpinBox->setValue(settings.value(SettingsDialog::LED_BORDER,
                                             SettingsDialog::LED_BORDER_DEFAULT).toInt());
    ui->ledSizeSpinBox->setValue(settings.value(SettingsDialog::LED_SIZE,
                                             SettingsDialog::LED_SIZE_DEFAULT).toInt());

    ui->showSecondsCheckBox->setChecked(settings.value(SettingsDialog::SHOW_SECONDS,
                                                       SettingsDialog::SHOW_SECONDS_DEFAULT).toBool());

    ui->useGrayCodeCheckBox->setChecked(settings.value(SettingsDialog::USE_GRAY_CODE,
                                                       SettingsDialog::USE_GRAY_CODE_DEFAULT).toBool());

#ifndef Q_WS_MAEMO_5
    ui->transparencySupportCheckBox->setChecked(settings.value(SettingsDialog::TRANSPARENCY,
                                                               SettingsDialog::TRANSPARENCY_DEFAULT).toBool());

    QStringList placementOptions;
    placementOptions.append(tr("Top"));
    placementOptions.append(tr("Normal"));
    placementOptions.append(tr("Bottom"));

    ui->widgetPlacementComboBox->addItems(placementOptions);
    ui->widgetPlacementComboBox->setCurrentIndex(settings.value(SettingsDialog::WIDGET_PLACEMENT,
                                                                SettingsDialog::WIDGET_PLACEMENT_DEFAULT).toInt());
#else
    ui->transparencySupportCheckBox->close();
    ui->transparencySupportLabel->close();

    ui->widgetPlacementComboBox->close();
    ui->widgetPlacementLabel->close();
#endif
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept(){
    QSettings settings;

    settings.setValue(SettingsDialog::CLOCK_LED_COLOR, ui->ledColorSelectionButton->getColor());
    settings.setValue(SettingsDialog::CLOCK_STYLE, ui->clockStyleComboBox->currentIndex());

    settings.setValue(SettingsDialog::LED_BORDER, ui->ledBorderSpinBox->value());
    settings.setValue(SettingsDialog::LED_SIZE, ui->ledSizeSpinBox->value());

    settings.setValue(SettingsDialog::SHOW_SECONDS, ui->showSecondsCheckBox->isChecked());

    settings.setValue(SettingsDialog::USE_GRAY_CODE, ui->useGrayCodeCheckBox->isChecked());

#ifndef Q_WS_MAEMO_5
    settings.setValue(SettingsDialog::TRANSPARENCY, ui->transparencySupportCheckBox->isChecked());
    settings.setValue(SettingsDialog::WIDGET_PLACEMENT, ui->widgetPlacementComboBox->currentIndex());
#endif

    settings.sync();

    done(1);
}
