/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CLOCKWIDGET_H
#define CLOCKWIDGET_H

#include <QColor>
#include <QSize>
#include <QTimer>
#include <QWidget>

#include <QMouseEvent>

class ClockWidget : public QWidget
{
    Q_OBJECT

public:
    explicit ClockWidget(QWidget *parent = 0);
    ~ClockWidget();

    virtual QSize sizeHint() = 0;

public slots:
    virtual void applySettings();
    void resumeClock(bool pause);

signals:
    void settingsChanged();

protected:
    bool showSeconds;

protected slots:
    virtual void updateTime() = 0;

private:
    QTimer *timer;
};

#endif // CLOCKWIDGET_H
