/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "horizontalbinarydisplaywidget.h"

HorizontalBinaryDisplayWidget::HorizontalBinaryDisplayWidget(int bits, int value, int height, QWidget *parent) :
    BinaryDisplayWidget(bits, value, height, parent)
{
}

void HorizontalBinaryDisplayWidget::draw(QPainter *painter){
    for(int i = 0; i < bits; i++){
        drawLed(((height - bits) * baseSize) + (baseSize * i),
                0,
                ((value & (1 << (bits - i - 1))) > 0),
                painter);
    }
}

QSize HorizontalBinaryDisplayWidget::sizeHint(){
    return QSize(baseSize * height, baseSize);
}

