#!/bin/sh

case "$1" in
	'-'[Ii] | '--install')
		orig=`find /usr/share/pixmaps/* -name "*.orig"`
		if [ "${orig}" ]; then
			# remove the replacement icons
			rm /usr/share/pixmaps/fcamera.png
			rm /usr/share/pixmaps/noor.png
			rm /usr/share/pixmaps/app-search-widget.png
			rm /usr/share/pixmaps/quicklaunch-search.png
			rm /usr/share/pixmaps/kwifimanager_big.png
			rm /usr/share/pixmaps/wlan_off.png
			# restore the original icons
			mv /usr/share/pixmaps/fcamera.png.orig /usr/share/pixmaps/fcamera.png
			mv /usr/share/pixmaps/noor.png.orig /usr/share/pixmaps/noor.png
			mv /usr/share/pixmaps/app-search-widget.png.orig /usr/share/pixmaps/app-search-widget.png
			mv /usr/share/pixmaps/quicklaunch-search.png.orig /usr/share/pixmaps/quicklaunch-search.png
			mv /usr/share/pixmaps/kwifimanager_big.png.orig /usr/share/pixmaps/kwifimanager_big.png
			mv /usr/share/pixmaps/wlan_off.png.orig /usr/share/pixmaps/wlan_off.png
			echo "Restored the old originals"
			# backing up originals
			mv /usr/share/pixmaps/fcamera.png /usr/share/pixmaps/fcamera.png.orig
			mv /usr/share/pixmaps/noor.png /usr/share/pixmaps/noor.png.orig
			mv /usr/share/pixmaps/app-search-widget.png /usr/share/pixmaps/app-search-widget.png.orig
			mv /usr/share/pixmaps/quicklaunch-search.png /usr/share/pixmaps/quicklaunch-search.png.orig
			mv /usr/share/pixmaps/kwifimanager_big.png /usr/share/pixmaps/kwifimanager_big.png.orig
			mv /usr/share/pixmaps/wlan_off.png /usr/share/pixmaps/wlan_off.png.orig
			# copy the replacement icons
			cp /usr/share/icons/awoken-icon-theme/extras/fcamera.png /usr/share/pixmaps/fcamera.png
			cp /usr/share/icons/awoken-icon-theme/extras/noor.png /usr/share/pixmaps/noor.png
			cp /usr/share/icons/awoken-icon-theme/extras/app-search-widget.png /usr/share/pixmaps/app-search-widget.png
			cp /usr/share/icons/awoken-icon-theme/extras/quicklaunch-search.png /usr/share/pixmaps/quicklaunch-search.png
			cp /usr/share/icons/awoken-icon-theme/extras/kwifimanager_big.png /usr/share/pixmaps/kwifimanager_big.png
			cp /usr/share/icons/awoken-icon-theme/extras/wlan_off.png /usr/share/pixmaps/wlan_off.png
			
		else
			# backing up
			mv /usr/share/pixmaps/fcamera.png /usr/share/pixmaps/fcamera.png.orig
			mv /usr/share/pixmaps/noor.png /usr/share/pixmaps/noor.png.orig
			mv /usr/share/pixmaps/app-search-widget.png /usr/share/pixmaps/app-search-widget.png.orig
			mv /usr/share/pixmaps/quicklaunch-search.png /usr/share/pixmaps/quicklaunch-search.png.orig
			mv /usr/share/pixmaps/kwifimanager_big.png /usr/share/pixmaps/kwifimanager_big.png.orig
			mv /usr/share/pixmaps/wlan_off.png /usr/share/pixmaps/wlan_off.png.orig
			# copy the replacement icons
			cp /usr/share/icons/awoken-icon-theme/extras/fcamera.png /usr/share/pixmaps/fcamera.png
			cp /usr/share/icons/awoken-icon-theme/extras/noor.png /usr/share/pixmaps/noor.png
			cp /usr/share/icons/awoken-icon-theme/extras/app-search-widget.png /usr/share/pixmaps/app-search-widget.png
			cp /usr/share/icons/awoken-icon-theme/extras/quicklaunch-search.png /usr/share/pixmaps/quicklaunch-search.png
			cp /usr/share/icons/awoken-icon-theme/extras/kwifimanager_big.png /usr/share/pixmaps/kwifimanager_big.png
			cp /usr/share/icons/awoken-icon-theme/extras/wlan_off.png /usr/share/pixmaps/wlan_off.png
		fi
			echo "Replacing the pixmaps icons are done. Restart and the new icons should be shown"
	;;
	'-'[Uu] | '--uninstall')
		# remove the replacement icons
		rm /usr/share/pixmaps/fcamera.png
		rm /usr/share/pixmaps/noor.png
		rm /usr/share/pixmaps/app-search-widget.png
		rm /usr/share/pixmaps/quicklaunch-search.png
		rm /usr/share/pixmaps/kwifimanager_big.png
		rm /usr/share/pixmaps/wlan_off.png
		# restore the original icons
		mv /usr/share/pixmaps/noor.png.orig /usr/share/pixmaps/fcamera.png
		mv /usr/share/pixmaps/noor.png.orig /usr/share/pixmaps/noor.png
		mv /usr/share/pixmaps/app-search-widget.png.orig /usr/share/pixmaps/app-search-widget.png
		mv /usr/share/pixmaps/quicklaunch-search.png.orig /usr/share/pixmaps/quicklaunch-search.png
		mv /usr/share/pixmaps/kwifimanager_big.png.orig /usr/share/pixmaps/kwifimanager_big.png
		mv /usr/share/pixmaps/wlan_off.png.orig /usr/share/pixmaps/wlan_off.png
		echo "Restoring the original pixmaps icons are done. Restart and the old icons should be shown"
	;;
esac


