# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Module implementing MainWindow GUI, anselA
"""
import os
import sys
import webbrowser

from PIL import Image
from PyQt4 import QtCore as QtCore
from PyQt4 import QtGui as QtGui
from PyQt4.QtGui import QMainWindow

from core.browser import *
from core.buttons import *
from core.config import *
from core.core import *
from core.files import *
from filters.bw import *
from filters.colors import *
from filters.crop import *
from filters.histogram import *
from filters.imageExif import *
from filters.levels import *
from filters.rotate import *
from filters.simple import *
from ui.Ui_mainWindow import Ui_MainWindow


class MainWindow(QMainWindow, Ui_MainWindow,  ParamValues):
    """
    Main Window Class for AnselA
    """
    core=ParamValues()

    #######################################
    #   Initial 
    #######################################

    def __init__(self, parent = None):
        """
        Constructor
        """
        try:
            QMainWindow.__init__(self, parent)
            self.setupUi(self)

        except:
            print "Error: init"
            return
            
    def postShow(self):
        try:
            ##ReadConfig(self)
            PhotTabs_Hide(self)
            WaitOverlay(self,"Starting...")
            ##FullScreenToggle(self,True, 2)
            self.tabStrip.setCurrentIndex(2)
            ##self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 0, 0, 0))
            self.photo.setMouseTracking= True
            populatePhotoList(self)
            WaitOverlayHide(self)
            ##reply = QtGui.QMessageBox.question(self, 'Message',"Are you sure to quit?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
       
            if (self.listPhotos.item(0) == None):
                FileImageOpen(self,  self.core.curImageLoc)
            ShowApply(self, False)
            self.core.plotIm=Image.open("ui/resources/graph.png") 
        except:
            print "Error: Init Fail"
            
    #######################################
    #   Tabs Change
    #######################################
    
    def on_tabPhoto_currentChanged(self, index):
        if (self.tabPhoto.count != 1):
            if (index == 2):
                ##self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 0, 0, 0))
                if self.core.thumbsCount == 0:
                    return populatePhotoList(self)
                self.photoListZoom.setVisible(False)
            elif (index ==1):
               self.loadUndoImages()
        else:
            #self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 0, 0, 0))
            if self.core.thumbsCount == 0:
                return populatePhotoList(self)

    def on_tabStrip_currentChanged(self, index):
        if (index==9):
            self.FramePopup.setGeometry(QtCore.QRect(0, 0, 800, 480))
        elif  (index==6):
            ReturnHistPlots(self)
        elif (index==0):
            self.PopulateEXIFData(self.core.curImageLoc)
        elif (index==7):
            self.core.SetCurrentTab(self.tabStrip.currentIndex())
            self.PopSizes()
        else:
            self.core.SetCurrentTab(self.tabStrip.currentIndex())

    #######################################
    #   Color Sliders
    #######################################
    def on_cSlide_B_valueChanged(self, value):
        self.core.valB = cSlide_SetValue(self, value,  self.core.valB,  self.lcdB, self.cSlide_B,  "B", self.core.displayUpdating)
    def on_btnSlide_B_dn_pressed(self):
        self.core.valB -= 1
        self.cSlide_B.setValue(self.core.valB)
    def on_btnSlide_B_up_pressed(self):
        self.core.valB += 1
        self.cSlide_B.setValue(self.core.valB)        
        
    def on_cSlide_R_valueChanged(self, value):
        self.core.valR = cSlide_SetValue(self, value,  self.core.valR,  self.lcdR, self.cSlide_R,  "R", self.core.displayUpdating)
    def on_btnSlide_R_dn_pressed(self):
        self.core.valR -= 1
        self.cSlide_R.setValue(self.core.valR)
    def on_btnSlide_R_up_pressed(self):
        self.core.valR += 1
        self.cSlide_R.setValue(self.core.valR)
        
    def on_cSlide_G_valueChanged(self, value):
        self.core.valG = cSlide_SetValue(self, value,  self.core.valG,  self.lcdG, self.cSlide_G,  "G", self.core.displayUpdating)        
    def on_btnSlide_G_dn_pressed(self):
        self.core.valG -= 1
        self.cSlide_G.setValue(self.core.valG)
    def on_btnSlide_G_up_pressed(self):
        self.core.valG += 1
        self.cSlide_G.setValue(self.core.valG)
    

  
    #######################################
    #   Level Applys
    #######################################
    def on_cSlide_Hi_valueChanged(self, value):
        self.core.valHi = cSlide_SetValue(self, value,  self.core.valHi,  self.lcdHi, self.cSlide_Hi,  "Hi", self.core.displayUpdating)
    def on_btnSlide_H_dn_pressed(self):
        self.core.valHi -= 1
        self.cSlide_Hi.setValue(self.core.valHi)
    def on_btnSlide_H_up_pressed(self):
        self.core.valHi += 1
        self.cSlide_Hi.setValue(self.core.valHi)
  
    def on_cSlide_Mi_valueChanged(self, value):
        self.core.valMi = cSlide_SetValue(self, value,  self.core.valMi,  self.lcdMi, self.cSlide_Mi,  "Any", self.core.displayUpdating)
    def on_btnSlide_Mid_dn_pressed(self):
        self.core.valMi -= 1
        self.cSlide_Mi.setValue(self.core.valMi)            
    def on_btnSlide_Mid_up_pressed(self):
        self.core.valMi += 1
        self.cSlide_Mi.setValue(self.core.valMi)

    def on_cSlide_Sw_valueChanged(self, value):
        self.core.valSw = cSlide_SetValue(self, value,  self.core.valSw,  self.lcdSw, self.cSlide_Sw,  "Sw", self.core.displayUpdating)        
    def on_btnSlide_Sha_dn_pressed(self):
        self.core.valSw -= 1
        self.cSlide_Sw.setValue(self.core.valSw)
    def on_btnSlide_Sha_up_pressed(self):
        self.core.valSw += 1
        self.cSlide_Sw.setValue(self.core.valSw)

    #######################################
    #   Simple Applys
    #######################################
    def on_cSlide_Co_valueChanged(self, value):
        self.core.valCo = cSlide_SetValue(self, value,  self.core.valCo,  self.lcdCo, self.cSlide_Co,  "Co", self.core.displayUpdating)
    def on_btnSlide_Co_dn_pressed(self):
        self.core.valCo -= 1
        self.cSlide_Co.setValue(self.core.valCo)
    def on_btnSlide_Co_up_pressed(self):
        self.core.valCo += 1
        self.cSlide_Co.setValue(self.core.valCo)
    
    def on_cSlide_Sh_valueChanged(self, value):
        self.core.valSh = cSlide_SetValue(self, value,  self.core.valSh,  self.lcdSh, self.cSlide_Sh,  "Sh", self.core.displayUpdating)            
    def on_btnSlide_Sh_dn_pressed(self):
        self.core.valSh -= 1
        self.cSlide_Sh.setValue(self.core.valSh)
    def on_btnSlide_sh_up_pressed(self):
        self.core.valSh += 1
        self.cSlide_Sh.setValue(self.core.valSh)
        
    def on_cSlide_Sa_valueChanged(self, value):
        self.core.valSa = cSlide_SetValue(self, value,  self.core.valSa,  self.lcdSa, self.cSlide_Sa,  "Sa", self.core.displayUpdating)    
    def on_btnSlide_Sa_up_pressed(self):
        self.core.valSa += 1
        self.cSlide_Sa.setValue(self.core.valSa)
    def on_btnSlide_Sa_dn_pressed(self):
        self.core.valSa -= 1
        self.cSlide_Sa.setValue(self.core.valSa)
    
    def on_cSlide_Br_valueChanged(self, value):
        self.core.valBr = cSlide_SetValue(self, value,  self.core.valBr,  self.lcdBr, self.cSlide_Br,  "Br", self.core.displayUpdating)
    def on_btnSlide_Br_dn_pressed(self):
        self.core.valBr -= 1
        self.cSlide_Br.setValue(self.core.valBr)
    def on_btnSlide_Br_up_pressed(self):
        self.core.valBr += 1
        self.cSlide_Br.setValue(self.core.valBr)
        
    #######################################
    #   B & W Settings
    #######################################
    def on_btn_Grey_released(self):
        self.core.valBW = "L"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_Red_released(self):
        self.core.valBW = "R"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_Green_released(self):
        self.core.valBW = "G"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_Blue_released(self):
        self.core.valBW = "B"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_Yellow_released(self):
        self.core.valBW = "Y"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_Cyan_released(self):
        self.core.valBW = "C"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_Magenta_released(self):
        self.core.valBW = "M"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_BC_released(self):
        self.core.valBW = "BC"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_GC_released(self):
        self.core.valBW = "GC"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_GY_released(self):
        self.core.valBW = "GY"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_BM_released(self):
        self.core.valBW = "BM"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_RM_released(self):
        self.core.valBW = "RM"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    def on_btn_RY_released(self):
        self.core.valBW = "RY"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)

#######################################
    #   Rotation
    ####################################### 
            
    ##@pyqtSignature("int")
    def on_dial_valueChanged(self, value):
        if  self.ResetRotSliders("Dial"):
            self.core.valRot = value
            self.lcdRot_1.setText(str(self.core.valRot))
            RotateThumb(self,  value)
           
    def on_btn_rot_Vert_released(self):
        if  self.ResetRotSliders("FlipV"):
            self.core.flipRight = not self.core.flipRight 
            FlipThumb(self)
        
    def on_btn_rot_Horz_pressed(self):
        if   self.ResetRotSliders("FlipH"):
            self.core.flipBottom = not self.core.flipBottom 
            FlipThumb(self)
        
    def on_btn_rot_90cw_released(self):
        if  self.ResetRotSliders("Rot"):
            self.core.flipAng = 270
            FlipThumb(self)

    def on_btn_rot_90ccw_released(self):
        if  self.ResetRotSliders("Rot"):
            self.core.flipAng = 90
            FlipThumb(self)
        
    def on_btn_rot_180_released(self):
        if self.ResetRotSliders("Rot"):
            if self.core.flipAng == 180:
                self.core.flipAng = 0
            else:
                self.core.flipAng = 180
            FlipThumb(self)
    
    def ResetRotSliders(self,  State):
        if  (self.core.lockUpdating == False):
            if State=="FlipH":
                self.core.flipRight = False
                self.core.flipAng = 0
                self.dial.setValue(0)
            if State=="FlipV":
                self.core.flipBottom = False
                self.core.flipAng = 0
                self.dial.setValue(0)
            elif State=="Rot":
                self.dial.setValue(0)
                self.core.flipRight =False
                self.core.flipBottom =False
            elif State=="Dial":    
                self.core.flipAng = 0
                self.core.flipRight =False
                self.core.flipBottom =False
            return True
        else:
            return False
            
    #######################################
    #   UI Reactions
    #######################################

    def on_btnExitCancel_released(self):
        self.showFullScreen()
        self.tabStrip.setCurrentIndex(self.core.GetCurrentTab(self))
        self.FramePopup.setGeometry(QtCore.QRect(0, 0, 0, 0))
        
    def on_btnPopOk_released(self):
        sys.exit()
    
    def on_btnPopCancel_released(self):
        self.showFullScreen()
        self.tabStrip.setCurrentIndex(self.core.GetCurrentTab(self))
        self.FramePopup.setGeometry(QtCore.QRect(0, 0, 0, 0))

    def on_photo_released(self):
        QMessageBox.information(self, "Loading Data", "Please wait while the data is retrieved...")

    def on_btnOpen_released(self):
        return FileOpenReleased(self)
    
    def PopulateEXIFData(self,  filename):
        return ImageExifLoad(self)
    
    def loadUndoImages(self):
        self.btnUndoCancel.setVisible(False)
        self.btnUndoGo.setVisible(False)
        i = 0
        self.listUndoList.clear()
        for uIm in self.core.undoList_IM:
            icon =QtGui.QIcon(pil2qpixmap(uIm.thumb))
            if (i == 0):
                self.listUndoList.addItem("Original")
            else:
                self.listUndoList.addItem("Step: "+str(i))
                
            self.listUndoList.item(i).setIcon(icon)
            i+=1
                

    #######################################
    #  Full Screen
    #######################################
    def on_btnFullScreen_released(self):
        FullScreenToggle(self,True)

    def on_btnFullScreenClose_released(self):
        FullScreenToggle(self,False)
    

    #######################################
    #   Photo Browser
    #######################################
    def on_btnPListCancel_released(self):
        self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.core.populatePhotoList = False

    def on_btnPlistZoom_released(self):
        ##AnimateWidget(self, self.photoListZoom, 170-int(self.photoListZoom.width()/2) , 200-int(self.photoListZoom.height()/2), 0, 0, 7)
        LoadCurImageFromPhotoBrowser(self)

    def on_btnEdit_pressed(self):
        ##AnimateWidget(self, self.photoListZoom, 40, 0, 0, 0, 10)
        LoadCurImageFromPhotoBrowser(self)

    def on_listPhotos_itemDoubleClicked(self, item):
        ##((155-int(self.photoListZoom.width()/2)) , 0, 0, 0, 10))
        ##AnimateWidget(self, self.photoListZoom, 170-int(self.photoListZoom.width()/2) , 200-int(self.photoListZoom.height()/2), 0, 0, 10)
        LoadCurImageFromPhotoBrowser(self)

    def on_butReturn_released(self):
        if not self.core.SomethingLoad:
            self.listPhotositemLoad(self.listPhotos.item(0))
            LoadCurImageFromPhotoBrowser(self)
        FullScreenToggle(self,False)
    
    def on_btnReloadPList_released(self):
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 800, 480))
    
    def on_btnReloadCancel_released(self):
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
    
    def on_btnReloadGo_released(self):
        #self.btnEdit.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
        populatePhotoList(self,  True)
  
    def on_btnRefresh_pressed(self):
        populatePhotoList(self)

    def on_btnPhotoBrowser_released(self):
        FullScreenToggle(self,True,  2)
        
        if self.core.thumbsCount == 0:
            self.populatePhotoList(self,  True)
    
    def on_listPhotos_itemClicked(self, item):
       #return listPhotosClicked()
        if str(item.text()) == "Load More...":
            self.core.thumbsCount +=70
            populatePhotoList(self,  False)

        else:
            self.listPhotositemLoad(item)
            
    def listPhotositemLoad(self, item):
        if (item <> None):
            
            self.core.plistIm= item.getImageLocation()
            im = Image.open(self.core.plistIm)
            item.rotation= GetExifRotation(self, item.imageLocation)
            im = rotateImage(self, im, item.rotation)
            
            wTh,  hTh = convertImSize(self.core, im.size[0], im.size[1],  300,  180, item.rotation,  1) #This should be the same size as the thumbnailbnails
            item.setIconZoomSize(ScaleLabel(self, 170, 200, wTh, hTh))
            
            self.photoListZoom.setGeometry(item.getIconZoomSize())
            self.btnPlistZoom.setGeometry(self.photoListZoom.geometry())
            
            plistTim=im.resize((hTh,  wTh))
            self.photoListZoom.setPixmap(pil2qpixmap(plistTim))
            
            self.photoListZoom.setVisible(True)
            self.photoListZoom.repaint()
        

    def on_listUndoList_itemPressed(self, item):
        self.btnUndoCancel.setVisible(True)
        self.btnUndoGo.setVisible(True)
        if (str(item.text()) == "Original"):
            self.core.undoSelected = 0
        else:
            self.core.undoSelected = str(item.text().replace("Step: ",""))
        self.btnUndoGo.setText("Revert to "+str(item.text()))



    
    #######################################
    #   Apply and Undo
    #######################################
    def on_btnApply_released(self):
        """
        Apply based on tab selection
        """
        ApplyGo(self)

    def on_btnUndoGo_released(self):
        UndoGo(self)
       
   
    #######################################
    #   Save As
    #######################################
    def on_btnSaveAs_released(self):
        DisplaySaveAs(self)

    def on_btnSaveAsCancel_pressed(self):
        self.frameSaveAs.setGeometry(0, 40, 0, 480)
       
    def on_btnSaveAsGo_pressed(self):
        WaitOverlay(self,"Saving File...")
        self.frameSaveAs.setGeometry(0, 40, 0, 480)
        try:
            self.core.current.image.save(self.btnSaveAsFilenameString().replace("JPEG", "jpg"), str(self.btnSaveAs_Combo.currentText()))
        except IOError:
            WaitOverlayOk(self,"Error: Could Not Write File")
        except:
            WaitOverlayOk(self,"Error: Failed to Save")
        finally:
            WaitOverlayOk(self,"Save Completed")
        
    def btnSaveAsFilenameString(self):
        return str(self.btnSaveAs_Location.text())+"/"+str(self.btnSaveAs_Filename.text())+"."+str(self.btnSaveAs_Combo.currentText())
        
    def btnSaveAsfindFileExists(self):
        if os.path.isfile(self.btnSaveAsFilenameString()):
            self.btnSaveAsGo.setEnabled(False)
        else:
            self.btnSaveAsGo.setEnabled(True)
            
    def btnSaveAsGenFilename(self, Dir, File):
        i=1
        while os.path.isfile(Dir+File+"_"+str(i)):
            i +=1
        return i
        
    def on_btnSaveAs_Combo_editTextChanged(self, p0):
        self.btnSaveAsfindFileExists()
        
    def on_btnSaveAs_Location_textChanged(self, p0):
        self.btnSaveAsfindFileExists()
        
    def on_btnSaveAs_Filename_textChanged(self, p0):
        self.btnSaveAsfindFileExists()
    
    def on_btnSaveAsCancelOut_pressed(self):
        self.frameSaveAs.setGeometry(0, 40, 0, 480)
        
    def on_btnSaveAsMore_pressed(self):
        if (str(self.btnSaveAsMore.text()) == "More"):
            self.btnSaveAsMore.setText("Less")
            self.frameSaveAuto.setVisible(False)
            self.frameSaveAvd.setVisible(True)
        else:
            self.btnSaveAsMore.setText("More")
            self.frameSaveAvd.setVisible(False)
            self.frameSaveAuto.setVisible(True)

    def on_btnPopWaitOk_pressed(self):
        WaitOverlayHide(self,)
        
    def on_btnApplyUndo_pressed(self):
        self.loadUndoImages()
        FullScreenToggle(self,True,  1)
    
    def on_btnRefreshExp_pressed(self):
        if (str(self.btnRefreshExp.text()) =="+"):
            self.btnRefreshExp.setText("-")
            self.btnReloadPList.setGeometry(QtCore.QRect(350, 370, 101, 51))
            self.btnOpen.setGeometry(QtCore.QRect(450, 370, 111, 51))
            self.btnRefresh.setGeometry(QtCore.QRect(200, 370, 151, 51))
        else:
            self.btnRefreshExp.setText("+")
            self.btnReloadPList.setGeometry(QtCore.QRect(400, 370, 111, 0))
            self.btnOpen.setGeometry(QtCore.QRect(510, 370, 111, 0)) 
            self.btnRefresh.setGeometry(QtCore.QRect(200, 370, 151, 0))
    
    
    def on_btnSaveSettings_pressed(self):
        populatePhotoList(self, True)
        

    #######################################
    #   Web Buttons
    #######################################
    def on_btnBlog_pressed(self):
        try:
            webbrowser.open_new('http://ansel-a.blogspot.com/')     
        except:
            return
        #url='http://ansel-a.blogspot.com/'      #os.system('browser --url=%s' %url)
        
    def on_btnBug_released(self):
        try:
            webbrowser.open_new('https://bugs.maemo.org/enter_bug.cgi?product=AnselA')     
        except:
            return
        
    def on_btnPopMinimize_released(self):
        self.showNormal()
    
    #######################################
    #   Crop and Resize  Buttons
    #######################################  
    def PopSizes(self):
        w, h = self.core.current.image.size
        self.core.valCropTop=0
        self.core.valCropBottom=h
        self.core.valCropLeft=0
        self.core.valCropRight=w
        self.txtSize_W.setText(str(w))
        self.txtSize_H.setText(str(h))
        self.txtSize_T.setText(str(self.core.valCropTop))
        self.txtSize_L.setText(str(self.core.valCropLeft))
        self.txtSize_B.setText(str(self.core.valCropBottom))
        self.txtSize_R.setText(str(self.core.valCropRight))
    
    def on_cropScrollTop_valueChanged(self, value):
        if self.core.displayUpdating == False:
            w,  h = self.core.current.image.size
            self.core.valCropTop=int((h*(float(value)/100.0)))
            if self.core.valCropTop >= self.core.valCropBottom:
                self.core.valCropTop = self.core.valCropBottom
            self.txtSize_T.setText(str(self.core.valCropTop))
            CropThumb(self)    
   
    def on_cropScrollBottom_valueChanged(self, value):
        if self.core.displayUpdating == False:
            w,  h = self.core.current.image.size
            self.core.valCropBottom=int(h*(float(value)/100.0))
            if self.core.valCropBottom <= self.core.valCropTop:
                self.core.valCropBottom = self.core.valCropTop
            self.txtSize_B.setText(str(self.core.valCropBottom))
            CropThumb(self)
    
    def on_cropScrollLeft_valueChanged(self, value):
        if self.core.displayUpdating == False:
            w,  h = self.core.current.image.size
            self.core.valCropLeft=int((w*(float(value)/100.0)))
            if self.core.valCropLeft >= self.core.valCropRight:
                self.core.valCropLeft = self.core.valCropRight
            self.txtSize_L.setText(str(self.core.valCropLeft))
            CropThumb(self)
        
    def on_cropScrollRight_valueChanged(self, value):
        if self.core.displayUpdating == False:
            w,  h = self.core.current.image.size
            self.core.valCropRight=int(w*(float(value)/100.0))
            if self.core.valCropLeft >= self.core.valCropRight:
                self.core.valCropRight = self.core.valCropLeft
                self.core.valCropRight = self.core.valCropLeft
            self.txtSize_R.setText(str(self.core.valCropRight))
            CropThumb(self)
    
    def on_btnShowMap_pressed(self):
        self.webView.load(QtCore.QUrl("http://maps.google.com/maps/api/staticmap?center=" + str(self.core.GPSLatRef*self.core.GPSLat) + "," + str(self.core.GPSLonRef*self.core.GPSLon) + "&zoom=14&size=450x350&maptype=roadmap&markers=color:blue|" + str(self.core.GPSLatRef*self.core.GPSLat) + "," + str(self.core.GPSLonRef*self.core.GPSLon) + "&sensor=false"))
        self.labLatLon.setText("Photo GPS Position - Lat:" + str(self.core.GPSLatRef*self.core.GPSLat) + ",Lon:" + str(self.core.GPSLonRef*self.core.GPSLon))
        self.webView.show()
        self.frameBrowserMap.setGeometry(QtCore.QRect(0, 0, 800, 480))
    
    def on_btnMapClose_pressed(self):
        self.frameBrowserMap.setGeometry(QtCore.QRect(0, 0, 0, 480))
    

    def on_SearchPhoto_On_toggled(self, checked):
        self.core.SearchOn = checked
        
    def on_SearchPhoto_Mcc_toggled(self, checked):
        self.core.SearchMMC = checked
