# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher Cacher
2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import threading, gobject
from Queue import Queue
from advpowcommon.util.singleton import Singleton
from advpowcommon.ui.Banners import HildonBanner

gobject.threads_init()

class WorkerThread(Singleton):

  def __init__(self, pool_size=1, prestart=False):
    Singleton.__init__(self)
    self.__started = prestart
    self.__queue = Queue()
    self.__pool_size = pool_size
    if prestart:
      self.__threads_init()

  def prestart(self):
    if self.__started:
      pass
    else:
      for i in range(self.__pool_size):
        t = threading.Thread(target=self.run)
        t.setDaemon(True)
        t.start()
      self.__started = True
    return self

  def run(self):
#      HildonBanner.show_information(target[1], 'get')
    while True:
      target = self.__queue.get(True)
      try:
        target[0](*target[1], **target[2])
      except:
        pass
      self.__queue.task_done()

  def shutdown(self, *args, **kwargs):
    if self.__started:
      self.__queue.join()

  def execute(self, target, args=[], kwargs={}):
    self.prestart()
    self.__queue.put_nowait((target, args, kwargs))

__worker = WorkerThread(2)
#__worker.start()

def get(): return __worker