/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DIALOG_H
#define DIALOG_H

#ifdef Q_WS_MAEMO_5
#include <gq/gconfitem.h>
#endif

#include <QColor>
#include <QDialog>

class GConfItem;

namespace Ui {
    class Dialog;
}

class Dialog : public QDialog
{
    Q_OBJECT

public:
    explicit Dialog(QWidget *parent = 0);
    ~Dialog();

    void accept();

    const static QString GCONF_PATH;
    const static QString GCONF_PATH_CLOCK;

public slots:
    void updateColor(QColor color);

private:
    Ui::Dialog *ui;

#ifdef Q_WS_MAEMO_5
    GConfItem *clockName;
    GConfItem *showSeconds;
    GConfItem *twelveHourMode;
    GConfItem *fill;
    GConfItem *showAlarmIndicator;
    GConfItem *colorR;
    GConfItem *colorG;
    GConfItem *colorB;
    GConfItem *fontName;
    GConfItem *textScaling;
    GConfItem *padZeros;
#endif

};

#endif // DIALOG_H
