#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import dbus
import dbus.mainloop.glib
import gconf
import gobject
import gtk
import hildon
import hildondesktop
import math
import pango
import pangocairo
import os
import re
import sys

PLUGIN_GCONF_DIR = "/apps/Maemo/advanced_clock_plugin"

sys.path.append("/usr/lib/advanced-clock-plugin")
import clock

clocks_path = "/usr/lib/advanced-clock-plugin/clocks"
sys.path.append(clocks_path)

clock_files = os.listdir(clocks_path)
py_files = re.compile("\.py$", re.IGNORECASE)
clock_files = filter(py_files.search, clock_files)
file_to_module = lambda f: os.path.splitext(f)[0]
clock_names = map(file_to_module, clock_files)
clocks = map(__import__, clock_names)


class AdvancedClockPlugin(hildondesktop.StatusMenuItem):
    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)

        self.init_gconf()

        self.clock = None
        self.clock_name = self.gconf_client.get_string(PLUGIN_GCONF_DIR + "/clock_name")
        self.clock_per_desktop = self.gconf_client.get_bool(PLUGIN_GCONF_DIR + "/clock_per_desktop")
        self.active = True
        self.time = None
        self.old_time = None

        self.view_id = self.gconf_client.get_int("/apps/osso/hildon-desktop/views/current")

# Status area menu entry is no longer used.
# Leaving this here as a placeholder just in case this might be needed again.
#
#        button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Advanced Clock")
#        image = gtk.Image()
#        image.set_from_file("/usr/share/icons/hicolor/64x64/apps/advanced-clock-plugin.png")
#        button.set_image(image)
#        button.set_alignment(0, 0.5, 0, 0)
#        button.connect("clicked", self.settings_cb)
#        self.add(button)
#        button.show()

        self.drawing_area = gtk.DrawingArea()
      	self.drawing_area.connect("expose-event", self.expose_cb)
        self.set_status_area_widget(self.drawing_area)
      	self.drawing_area.show()

        self.change_clock()
#        self.clock = getattr(clocks[clock_names.index(self.clock_name)], self.clock_name)(self.drawing_area)
#        self.clock.request_resize()

 #       self.show()

        gobject.timeout_add(1000, self.update_cb)

        dbus.mainloop.glib.DBusGMainLoop(set_as_default = True)
        self.dbus = dbus.SystemBus()
        self.dbus.add_signal_receiver(self.dbus_signal_cb, "display_status_ind", "com.nokia.mce.signal", None, "/com/nokia/mce/signal")
        self.dbus.add_signal_receiver(self.dbus_alarm_cb, "queue_status_ind", "com.nokia.alarmd", None, "/com/nokia/alarmd")

    def change_clock(self):
        view_id = None
        clock_name = "/clock_name"

        if self.clock_per_desktop and self.gconf_client.dir_exists(PLUGIN_GCONF_DIR + "/clock_" + str(self.view_id)) :
            view_id = self.view_id
            clock_name += "_" + str(self.view_id)

        old_clock = self.clock
        self.clock_name = self.gconf_client.get_string(PLUGIN_GCONF_DIR + clock_name)
        self.clock = getattr(clocks[clock_names.index(self.clock_name)], self.clock_name)(self.drawing_area, view_id)
        
        if old_clock is not None :
            self.clock.set_alarm_enabled(old_clock.get_alarm_enabled())
            self.clock.set_alarm_time(old_clock.get_alarm_time())

        self.clock.request_resize()
        self.drawing_area.queue_draw()

    def dbus_alarm_cb(self, alarms, desktop, actdead, noboot):
        if desktop != actdead :
            self.clock.set_alarm_enabled(True)
            self.clock.set_alarm_time(datetime.fromtimestamp(actdead))
        else :
            self.clock.set_alarm_enabled(False)
        self.drawing_area.queue_draw()

    def dbus_signal_cb(self, msg):
        if msg == "off" :
            self.active = False
        elif msg == "on" :
            self.update_cb()
            self.active = True
            gobject.timeout_add(1000, self.update_cb)

    def expose_cb(self, widget, event):
        self.clock.draw()
        return False

    def gconf_clock_name_cb(self, client, conn_id, entry, args):
        if entry.get_key() == PLUGIN_GCONF_DIR + "/clock_name" :
            self.clock_per_desktop = self.gconf_client.get_bool(PLUGIN_GCONF_DIR + "/clock_per_desktop")
            self.change_clock()
        
    def gconf_current_view_cb(self, client, conn_id, entry, args):
        self.view_id = entry.get_value().get_int()

        if self.clock_per_desktop :
            self.change_clock()

    def init_gconf(self):
        self.gconf_client = gconf.client_get_default()
        if not self.gconf_client.dir_exists(PLUGIN_GCONF_DIR) :
            self.gconf_client.set_string(PLUGIN_GCONF_DIR + "/clock_name", "DecimalClock")

        if not self.gconf_client.get(PLUGIN_GCONF_DIR + "/clock_per_desktop") :
            self.gconf_client.set_bool(PLUGIN_GCONF_DIR + "/clock_per_desktop", False)

        self.gconf_client.add_dir(PLUGIN_GCONF_DIR, gconf.CLIENT_PRELOAD_NONE)
        self.gconf_client.notify_add(PLUGIN_GCONF_DIR + "/clock_name", self.gconf_clock_name_cb)

        self.gconf_client.add_dir("/apps/osso/hildon-desktop/views", gconf.CLIENT_PRELOAD_NONE)
        self.gconf_client.notify_add("/apps/osso/hildon-desktop/views/current", self.gconf_current_view_cb)

    def update_cb(self):
        if self.time != None:
            self.old_time = self.time

        self.time = datetime.today()

        if self.clock.get_force_redraw() or self.clock.get_show_seconds() or (self.old_time is None) or (self.old_time.minute != self.time.minute):
            self.drawing_area.queue_draw()

        return self.active


hd_plugin_type = AdvancedClockPlugin


