#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

import BinaryClock

def get_name():
    return "Binary Clock showing the Alarm Time"

class BinaryAlarmClock(BinaryClock.BinaryClock):
    def __init__(self, drawing_area):
        BinaryClock.BinaryClock.__init__(self, drawing_area)

    def draw_bits_horizontally_with_alarm(self, x, y, radius, time, alarm, n):
        for i in range(n):
            self.context.set_source_rgb(self.color_r, self.color_g, self.color_b)
            self.context.arc(x + (1.5 * radius) + (3 * radius * i), y + radius, radius, 0, 2 * math.pi)
            if (time >> (n - i - 1) & 1) > 0:
                self.context.fill_preserve()
            if (alarm >> (n - i - 1) & 1) > 0:
                self.context.set_source_rgb(1.0, 0.0, 0.0)
            self.context.stroke()

    def draw_clock(self):
        if (not self.alarm_time) or (not self.alarm_enabled) :
            BinaryClock.BinaryClock.draw_clock(self)
            return None

        if self.show_seconds :
            self.draw_bits_horizontally_with_alarm(12, 2, 4, self.time.hour, self.alarm_time.hour, 5)
            self.draw_bits_horizontally_with_alarm(0, 14, 4, self.time.minute, self.alarm_time.minute, 6)
            self.draw_bits_horizontally_with_alarm(0, 26, 4, self.time.second, self.alarm_time.second, 6)
        else :
            self.draw_bits_horizontally_with_alarm(18, 2, 6, self.time.hour, self.alarm_time.hour, 5)
            self.draw_bits_horizontally_with_alarm(0, 20, 6, self.time.minute, self.alarm_time.minute, 6)

    def resize(self):
        if self.show_seconds :
            self.drawing_area.set_size_request(76, 36)
        else:
            self.drawing_area.set_size_request(110, 36)

