#include "weighttrackdialog.h"
#include "ui_weighttrackdialog.h"
#include <QDate>
#include <QTextStream>

WeightTrackDialog::WeightTrackDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::WeightTrackDialog)
{
    ui->setupUi(this);
    updating = false;

    QDate dToday;
    int iYear = dToday.currentDate().year();
    int iWeek = dToday.currentDate().weekNumber();

    ui->txtYear->setValue(iYear);
    ui->txtWeek->setValue(iWeek);

    LoadWeight();
    LoadGraph();
}



WeightTrackDialog::~WeightTrackDialog()
{
    delete ui;
}

void WeightTrackDialog::LoadGraph()
{
    int iYear = ui->txtYear->value();
    int iWeek = ui->txtWeek->value();
    double dmax=0;
    double dmin=0;

    for (int i=0; i <=12; i++)
    {
        int iCalcWeek = iWeek - i;
        int iCalcYear = iYear;
        if (iCalcWeek < 1)
        {
            iCalcYear = iYear-1;
            iCalcWeek  += 52;
        }
        QString sKey;
        QTextStream(&sKey) << "weight_kgs/" << iCalcYear << "_" << iCalcWeek;
        QString sKgs = mSelFood.value(sKey).toString();
        bool ok;

        double dWeight = sKgs.toDouble(&ok);
        if (ok)
        {
            if (dWeight > dmax)
            {
                dmax=dWeight;
            }
            if (dmin==0)
            {
                dmin=dWeight;
            }
            if (dWeight < dmin)
            {
                dmin=dWeight;
            }
            switch (i)
            {
                case 0:
                {
                    ui->pb0->setMinimum(dmin);
                    ui->pb0->setMinimum(dmin);
                    ui->pb0->setValue(dWeight);
                    break;
                }
                case 1:
                {
                    ui->pb1->setMinimum(dmin);
                    ui->pb1->setMinimum(dmin);
                    ui->pb1->setValue(dWeight);
                    break;
                }
                case 2:
                {
                    ui->pb2->setMinimum(dmin);
                    ui->pb2->setMinimum(dmin);
                    ui->pb2->setValue(dWeight);
                    break;
                }
                case 3:
                {
                    ui->pb3->setMinimum(dmin);
                    ui->pb3->setMinimum(dmin);
                    ui->pb3->setValue(dWeight);
                    break;
                }
                case 4:
                {
                    ui->pb4->setMinimum(dmin);
                    ui->pb4->setMinimum(dmin);
                    ui->pb4->setValue(dWeight);
                    break;
                }
                case 5:
                {
                    ui->pb5->setMinimum(dmin);
                    ui->pb5->setMinimum(dmin);
                    ui->pb5->setValue(dWeight);
                    break;
                }
                case 6:
                {
                    ui->pb7->setMinimum(dmin);
                    ui->pb7->setMinimum(dmin);
                    ui->pb7->setValue(dWeight);
                    break;
                }
                case 7:
                {
                    ui->pb7->setMinimum(dmin);
                    ui->pb7->setMinimum(dmin);
                    ui->pb7->setValue(dWeight);
                    break;
                }
                case 8:
                {
                    ui->pb8->setMinimum(dmin);
                    ui->pb8->setMinimum(dmin);
                    ui->pb8->setValue(dWeight);
                    break;
                }
                case 9:
                {
                    ui->pb9->setMinimum(dmin);
                    ui->pb9->setMinimum(dmin);
                    ui->pb9->setValue(dWeight);
                    break;
                }
                case 10:
                {
                    ui->pb10->setMinimum(dmin);
                    ui->pb10->setMinimum(dmin);
                    ui->pb10->setValue(dWeight);
                    break;
                }
                case 11:
                {
                    ui->pb11->setMinimum(dmin);
                    ui->pb11->setMinimum(dmin);
                    ui->pb11->setValue(dWeight);
                    break;
                }
                case 12:
                {
                    ui->pb12->setMinimum(dmin);
                    ui->pb12->setMinimum(dmin);
                    ui->pb12->setValue(dWeight);
                    break;
                }
            }

        }


    }

    dmin=dmin-5;
    dmax=dmax+5;

    ui->pb1->setMinimum(dmin);
    ui->pb1->setMinimum(dmin);
    ui->pb2->setMinimum(dmin);
    ui->pb2->setMinimum(dmin);
    ui->pb3->setMinimum(dmin);
    ui->pb3->setMinimum(dmin);
    ui->pb4->setMinimum(dmin);
    ui->pb4->setMinimum(dmin);
    ui->pb5->setMinimum(dmin);
    ui->pb5->setMinimum(dmin);
    ui->pb6->setMinimum(dmin);
    ui->pb6->setMinimum(dmin);
    ui->pb7->setMinimum(dmin);
    ui->pb7->setMinimum(dmin);
    ui->pb8->setMinimum(dmin);
    ui->pb8->setMinimum(dmin);
    ui->pb9->setMinimum(dmin);
    ui->pb9->setMinimum(dmin);
    ui->pb10->setMinimum(dmin);
    ui->pb10->setMinimum(dmin);
    ui->pb11->setMinimum(dmin);
    ui->pb11->setMinimum(dmin);
    ui->pb12->setMinimum(dmin);
    ui->pb12->setMinimum(dmin);
}

void WeightTrackDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

int WeightTrackDialog::round(double a)
{
    return int(a );
}


void WeightTrackDialog::KgsToStone()
{
    if (updating ) return;

    double dTotPounds = ui->txtKgs->value() * 2.20462262 ;
    QString text;
    int iValue = round( dTotPounds / 14);
    text.sprintf("%02d", iValue);
    int iStone = text.toInt();
    iValue = round( dTotPounds) % 14;
    text.sprintf("%02d", iValue);
    int iPounds = text.toInt();

    updating = true; // avoid recursive calls
    ui->txtStone->setValue(iStone);
    ui->txtPounds->setValue(iPounds);
    updating = false;

}

void WeightTrackDialog::StoneToKgs()
{
    if (updating ) return;

    int iStone = ui->txtStone->value();
    int iPounds = ui->txtPounds->value();
    int tot = (iStone *14) + iPounds;

    double dKgs = tot / 2.20462262;
    updating = true;
    ui->txtKgs->setValue(dKgs);
    updating = false;

}

void WeightTrackDialog::on_txtStone_valueChanged(int )
{
    StoneToKgs();
}

void WeightTrackDialog::on_txtPounds_valueChanged(int )
{
    StoneToKgs();
}

void WeightTrackDialog::on_txtKgs_valueChanged(double )
{
    KgsToStone();
}

void WeightTrackDialog::on_txtYear_valueChanged(int )
{
    LoadWeight();
}

void WeightTrackDialog::on_txtWeek_valueChanged(int )
{
    LoadWeight();
}


void WeightTrackDialog::LoadWeight()
{
    updating = true;

    QString sKey;
    QTextStream(&sKey) << "weight_kgs/" << ui->txtYear->value() << "_" << ui->txtWeek->value();
    QString sKgs = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "weight_stone/" << ui->txtYear->value() << "_" << ui->txtWeek->value();
    QString sStone = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "weight_pounds/" << ui->txtYear->value() << "_" << ui->txtWeek->value();
    QString sPounds = mSelFood.value(sKey).toString();

    if (sKgs=="")
    {
        ui->txtKgs->setValue(0);
    }
    else
    {
        ui->txtKgs->setValue(sKgs.toDouble());
    }


    if (sStone=="")
    {
        ui->txtStone->setValue(0);
    }
    else
    {
        ui->txtStone->setValue(sStone.toDouble());
    }

    if (sPounds=="")
    {
        ui->txtPounds->setValue(0);
    }
    else
    {
        ui->txtPounds->setValue(sPounds.toDouble());
    }

    updating=false;
}

void WeightTrackDialog::SaveWeight()
{
    updating = true;

    QString sKey;
    QString sValue;
    QTextStream(&sKey) << "weight_kgs/" << ui->txtYear->value() << "_" << ui->txtWeek->value();
    QTextStream(&sValue) << ui->txtKgs->value();
    mSelFood.setValue(sKey, sValue);

    sKey = ""; sValue="";
    QTextStream(&sKey) << "weight_stone/" << ui->txtYear->value() << "_" << ui->txtWeek->value();
    QTextStream(&sValue) << ui->txtStone->value();
    mSelFood.setValue(sKey, sValue);

    sKey = ""; sValue="";
    QTextStream(&sKey) << "weight_pounds/" << ui->txtYear->value() << "_" << ui->txtWeek->value();
    QTextStream(&sValue) << ui->txtPounds->value();
    mSelFood.setValue(sKey, sValue);

    updating=false;
}

void WeightTrackDialog::on_btnSave_clicked()
{
    SaveWeight();
    LoadGraph();
}

void WeightTrackDialog::on_btnClose_clicked()
{
    this->close();
}
