#include <QtGui/QApplication>
#include <QtDeclarative>

#if defined(USE_OPENGL)
#   include <QtOpenGL>
#endif

#include "AppControl.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    AppControl control;

    QDeclarativeView viewer(QUrl("/opt/usr/share/xbox360-media-remote/qml/main.qml"));
    viewer.rootContext()->setContextProperty("Control", &control);

    viewer.setWindowTitle("XBox360 Media Remote");

#if defined(USE_OPENGL)
    viewer.setViewport(new QGLWidget(QGLFormat(QGL::DoubleBuffer)));
    viewer.setViewportUpdateMode(QGraphicsView::FullViewportUpdate);
#endif

#if defined(Q_WS_MAEMO_5)
    viewer.showFullScreen();
#else
    viewer.setFixedSize(800, 480);
    viewer.show();
#endif

    return app.exec();
}
