from gnome import gconf
from wifi_assistant.gui.edit_network_dialog import EditNetworkDialog

import unittest
from unit.pie import *

ssid = 'Network Name'
iter = 'Really a GTK TreeView iter'

class EditNetworkDialogTest(unittest.TestCase):

    def setUp(self):
        self.parent_window = None
        self.save_callback = Mock()
        
        #given(self.save_callback).save().willReturn(None)
        self.save_callback.replay()
 
        self.testee = EditNetworkDialog(self.parent_window, self.save_callback.save)


    def test_clickingYesButtonCallsCallback(self):
        self._makeRunDialogReturn(EditNetworkDialog.YES_BUTTON)
        self.testee.show(iter, ssid)
        verify(self.save_callback).save(iter, ssid, True)


    def test_clickingNoButtonCallsCallback(self):
        self._makeRunDialogReturn(EditNetworkDialog.NO_BUTTON)
        self.testee.show(iter, ssid)
        verify(self.save_callback).save(iter, ssid, False)


    def test_cancellingDialogDoesntCallCallback(self):
        self._makeRunDialogReturn(-1)
        self.testee.show(iter, ssid)
        verify(self.save_callback, never()).save()


    def _makeRunDialogReturn(self, value):
        class method():
            def __init__(self, value_to_return):
                self._value_to_return = value_to_return
            def __call__(self, x):
                return self._value_to_return
        self.testee._runDialog = method(value)
        
    
if __name__ == '__main__':
    unittest.main()
