#!/usr/bin/python2.5
import gtk, hildon

def _(str):
    return str

class NetworkSettingsView():
    
    def __init__(self, list_store, parent_container, edit_network_settings_callback):
        """edit_network_settings_callback(ssid, model, iter)""" # FIXME: abstraction layer violation
        self._parent = parent_container
        self._model = list_store
        self._edit_network_settings_callback = edit_network_settings_callback
        
        self._active_widget = None
        self._zero_settings_label = gtk.Label(_('There are no settings saved for any network.'))
        self._network_settings_list = self._createNetworkSettingsList()

        self._registerListeners()
        
        
    def update(self, *args):
        if len(self._model) == 0:
            self._activateZeroSettingsLabel()
        else:
            self._activateNetworkSettingsList()
    
    
    def _activateNetworkSettingsList(self):
        self._activateWidget(self._network_settings_list)
        
    
    def _activateZeroSettingsLabel(self):
        self._activateWidget(self._zero_settings_label)
        

    def _activateWidget(self, widget):
        if self._active_widget is not None:
            self._parent.remove(self._active_widget)
            self._active_widget = None
        self._parent.add(widget)
        self._parent.show_all()
        self._active_widget = widget
    
    
    def _createNetworkSettingsList(self):
#        view = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL, model)
#        view = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL, model)

        view = gtk.TreeView(self._model)
        view.set_border_width(5)
        
        def boolean_func(column, cell, model, iter):
            if model.get_value(iter, 1):
                stock_id = 'gtk-yes'
            else:
                stock_id = 'gtk-no'
            cell.set_property('stock-id', stock_id)
        
        launch_cell = gtk.CellRendererPixbuf()
        launch_cell.set_fixed_size(100, 50)
        view.insert_column_with_data_func(1, _('Launch'), launch_cell, boolean_func)
#        toggle_cell = gtk.CellRendererToggle()
#        toggle_cell.set_fixed_size(100, 50)
#        view.append_column( gtk.TreeViewColumn( '', toggle_cell, active=1))
         
        tvcolumn = gtk.TreeViewColumn(_('SSID'), gtk.CellRendererText(), text=0)
        tvcolumn.set_expand(True)
        view.append_column(tvcolumn)
    
        view.connect('row-activated', self._rowActivatedCallback)
        view.set_search_column(0)
        tvcolumn.set_sort_column_id(0)
        
        return view


    def _registerListeners(self):
        self._model.connect("row-deleted", self.update)
        self._model.connect("row-inserted", self.update)
        
    # FIXME: use this to test:
    # _model.row_deleted(path)
    # _model.row_inserted(path, iter) 


    def _rowActivatedCallback(self, treeview, path, view_column):
        model = treeview.get_model()
        iter = model.get_iter(path)
        ssid = model.get_value(iter, 0)
        self._edit_network_settings_callback(ssid, model, iter)

