/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "volumelinechartwidget.h"

VolumeLineChartWidget::VolumeLineChartWidget(QWidget *parent) : VolumeMeterWidget(parent)
{
    volumeValues = new QList<float>();
    initValues();
}

void VolumeLineChartWidget::paintEvent(QPaintEvent */*event*/){
    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);

    painter.setViewport(0, 0, width(), height());
    painter.setWindow(0, 0, 300, 100);

    draw(& painter);
}

void VolumeLineChartWidget::draw(QPainter *painter){
    float vol;

#ifdef Q_WS_MAEMO_5
    QRectF background(0, 0, 300, 100);
    painter->fillRect(background, QBrush(Qt::white));

    QFont font = painter->font();
    font.setPointSizeF(font.pointSizeF()*0.6);
    painter->setFont(font);
#endif

    QPen grayPen(Qt::gray);
    grayPen.setWidth(1);

    QPen blackPen(Qt::black);
    blackPen.setWidth(1);

    if(dbUnit){
        vol = ((float) currentValue) / MAX_DB;

        for(int i = 0; i < (MAX_DB / 10); i++){
            float y = 95 - (94 / (MAX_DB / 10.) * i);

            if(i % 2 == 0){
                painter->setPen(blackPen);

                if(i > 0){
                    painter->drawLine(2, y, 272, y);
                }

                painter->drawText(275, y+3, QString().setNum(i*10));
            }else{
                painter->setPen(grayPen);
                painter->drawLine(2, y, 272, y);
            }
        }
    }else{
        vol = ((float) currentValue) / MAX_LINEAR;

        for(int i = 0; i <= (MAX_LINEAR / 10); i++){
            float y = 95 - (94 / (MAX_LINEAR / 10.)*i);

            if(i % 5 == 0){
                painter->setPen(blackPen);
                painter->drawLine(2, y, 272, y);

                if(i < 20){
                    painter->drawText(275, y+3, QString().setNum(i*10));
                }
            }else{
                painter->setPen(grayPen);
                painter->drawLine(2, y, 272, y);
            }
        }
    }

    volumeValues->removeFirst();
    volumeValues->append(vol);

    QRectF chartBackground(2, 2, 270, 94);
    painter->drawRect(chartBackground);

    QPen pen(Qt::darkBlue);
    pen.setWidth(1);
    painter->setPen(pen);

    for(int i = 0; i < 269; i++){
        painter->drawLine(i+2, 95 - (94 * volumeValues->at(i)), i+3, 95 - (94 * volumeValues->at(i+1)));
    }
}

void VolumeLineChartWidget::initValues(){
    for(int i = 0; i < 270; i++){
        volumeValues->append(0.);
    }
}

void VolumeLineChartWidget::setDbUnit(bool b){
    VolumeMeterWidget::setDbUnit(b);

    volumeValues->clear();
    initValues();
}
