import Qt 4.7

Item {
    property alias usernamefield: userInput.text
    property alias langtext: currentLang.text
    id: authBox
    x: screen.width > 720 ? -601 : -381
    // y: 200
    z: 5
    Behavior on x {
        SpringAnimation { mass: 0.8; spring: 8; damping: 0.3 }
    }
    Rectangle {
        id: inputArea
        width: screen.width > 720 ? 599 : 379
        //height: bottomSpacer.y + bottomSpacer.height
        //color: "grey"
        height: flows.height;

        smooth: true
        clip: true
        border.width: 1
        border.color: "grey"
        radius: 5
        gradient: boxgrad
        Gradient {
            id: boxgrad
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }

        Flow {
            id: flows
            Rectangle {
                id: loginBox
                width: 200
                height: childrenRect.height
                color: "transparent"
                Text {
                    id: label
                    text: "Username"
                    font.pointSize: 12
                    x: 10
                    y: 5
                }

                Rectangle {
                    id: userInputContainer
                    width: 170
                    height: 24
                    color: "white"
                    border.width: 1
                    border.color: "#cbcbcb"
                    radius: 5
                    x: 15
                    y: label.y + label.height + 3
                    TextInput {
                        x: 5
                        y: 2
                        selectByMouse: true
                        Keys.onReturnPressed: authBox.doLogin(userInput.text, passInput.text);
                        Keys.onEnterPressed: authBox.doLogin(userInput.text, passInput.text);
                        font.pointSize: 12
                        id: userInput
                        width: parent.width - 10
                        height: 24
                    }
                }
                Text {
                    id: label2
                    text: "Password"
                    font.pointSize: 12
                    x: 10
                    y: userInputContainer.y + userInputContainer.height + 5
                }

                Rectangle {
                    id: passInputContainer
                    width: 170
                    height: 24
                    color: "white"
                    border.width: 1
                    border.color: "#cbcbcb"
                    radius: 5
                    x: 15
                    y: label2.y + label2.height + 3
                    TextInput {
                        x: 5
                        y: 2
                        selectByMouse: true
                        Keys.onReturnPressed: authBox.doLogin(userInput.text, passInput.text);
                        Keys.onEnterPressed: authBox.doLogin(userInput.text, passInput.text);
                        font.pointSize: 12
                        id: passInput
                        echoMode: TextInput.Password
                        width: parent.width - 10
                        height: 24
                    }
                }

                NewButton {
                    useimg: false
                    x: parent.width - 5 - width
                    y: passInputContainer.y + passInputContainer.height + 5
                    text: "Login"
                    onClicked: authBox.doLogin(userInput.text, passInput.text)
                    id: postButton
                }

        /*        Button {
                    x: postButton.x - 5 - width
                    y: passInputContainer.y + passInputContainer.height + 5
                    text: "Test info"
                    onClicked: Notty.notify("Tweedsuit", "Yeah, it works :)");
                    id: testButton
                } */
                Rectangle {
                    id: bottomSpacer
                    y: postButton.y + postButton.height
                    height: 5
                    color: "transparent"
                }
            }

            Rectangle {
                id: setLang
                width: 180
                height: childrenRect.height
                color: "transparent";

                Text {
                    id: setLangLabel
                    text: "Translate language"
                    font.pointSize: 12
                    x: 10
                    y: 5
                }
                Rectangle {
                    y: setLangLabel.y + setLangLabel.height;
                    x: 10
                    id: currentLangBox
                    color: "white"
                    border.width: 1
                    border.color: "#cbcbcb"
                    radius: 5
                    width: 160
                    height: currentLang.height + 6
                    Text {
                        y: 3
                        x: 5
                        id: currentLang
                        font.pointSize: 12
                        text: screen.js().getLangName(screen.js().getLangSetting());
                    }
                    MouseArea {
                        anchors.fill: parent;
                        onClicked: {
                            if (langbox.opacity == 0) {
                                langlist.source = "LangList.qml"
                                langlist.anchors.fill = langboxcont;
                                langbox.opacity = 1;
                            } else {
                                langlist.source = ""
                                langbox.opacity = 0;
                            }
                        }

                    }

                }
                Rectangle {
                    y: currentLangBox.y + currentLangBox.height + 5
                    x: 10
                    id: langbox
                    color: "white"
                    border.width: 1
                    border.color: "#cbcbcb"
                    radius: 5
                    width: 160
                    opacity: 0
                    Behavior on opacity {
                        NumberAnimation { duration: 500; }
                    }
                    height: loginBox.height - y - 5;
                    Rectangle {
                        id: langboxcont
                        x: 5; y: 2; width: parent.width - 10; height: parent.height - 4;
                        color: "transparent"
                        clip: true
                        Loader { id: langlist; }
                    }
                }
            }
        }
    }
    Rectangle {
        id: dragArea
        width: 60
        height: 50
        //color: "grey"
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        smooth: true

        border.width: 1
        border.color: "grey"
        radius: 10
        x: inputArea.x + inputArea.width - 5
        y: inputArea.y + 10
        NewButton {
            anchors.centerIn: parent
            id: dragbutton
            z:2
            flat: true
            useimgsize:  true
            bsource: oauth.authorized ? "images/user_auth.png" : "images/user_noauth.png";
            onClicked: {
                if (authBox.state != "open") {
                    authBox.state = "open"
                    userInput.forceActiveFocus()
                    console.log("Opened");
                } else {
                    authBox.state = "closed";
                    console.log("Closed");
                    mainrow.forceActiveFocus()
                }
            }
            button.drag.axis: Drag.XAxis
            button.drag.target: authBox


            onReleased: {
                if (button.drag.active == true) {
                    if (authBox.state != "closed") {
                        if (authBox.x < 0) {
                            authBox.state = "closed"
                            mainrow.forceActiveFocus()
                        } else {
                            authBox.state = "move"
                            authBox.state = "open"
                            userInput.forceActiveFocus()
                        }
                    } else {
                        if (authBox.x > -541) {
                            authBox.state = "open"
                            userInput.forceActiveFocus()
                        } else {
                            authBox.state = "move"
                            authBox.state = "closed"
                            mainrow.forceActiveFocus()
                        }
                    }
                }
            }
        }
    }

    states: [
        State {
            name: "closed"
            PropertyChanges { target: authBox; x: screen.width > 720 ? -601 : -381 }
            PropertyChanges { target: inputArea; opacity: 0 }


        },

        State {
            name: "open"
            PropertyChanges { target: authBox; x: screen.width > 720 ? 60 : 50 }
            PropertyChanges { target: inputArea; opacity: 1 }
         },
        State {
            name: "move"
            when: dragbutton.button.drag.active == true
            PropertyChanges { target: inputArea; opacity: 1 }
        }
    ]
    function doLogin(username, password) {
        console.log ("Logging in with user " + username)
        storage.storeAuth(username, password);
        // console.log("Stored user " + username);
        authBox.state = "closed"
        mainrowModel.clear();
        oauth.token = "";
        oauth.secret = "";
        oauth.username = username;
        oauth.password = password;
        oauth.authorized = false;
        console.log("so far so good...");
        oauth.beginAuthentication();

        return true
    }
}
