
#include "qsettingsmanager.h"

QSettings *QSettingsManager::settings = NULL;

void QSettingsManager::checkSettingsObj()
{
    if (settings == NULL)
        settings = new QSettings();
}

void QSettingsManager::clearSettings()
{
    checkSettingsObj();
    settings->clear();
}

void QSettingsManager::storeSetting(const QString& key, const QVariant& value)
{
    checkSettingsObj();
    settings->setValue(key, value);
}

void QSettingsManager::removeSettingsStartingWith(const QString &str)
{
    foreach (QString key, QSettingsManager::settings->allKeys())
    {
        if (key.startsWith(str))
            QSettingsManager::settings->remove(key);
    }
}

QVariant QSettingsManager::retrieveSetting(const QString& key, const QVariant &defaultValue)
{
    checkSettingsObj();
    if (settings->contains(key))
        return settings->value(key);
    return defaultValue;
}


const QSettings *QSettingsManager::qsettingsInstance()
{
    checkSettingsObj();
    return settings;
}
