#include <QtGui/QApplication>
#include <QDeclarativeView>
#include <QDeclarativeContext>
#include <QObject>
#include <QString>
#include "Notty.h" //notifications

#if defined(USE_OPENGL)
#   include <QtOpenGL>
#endif

#define QT_USE_FAST_CONCATENATION
#define QT_USE_FAST_OPERATOR_PLUS

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QDeclarativeView viewer;
    viewer.setSource(QString("qrc:TweedUI/tweedsuit.qml"));
    Notty notty; // Notification object
    viewer.rootContext()->setContextProperty("Notty", &notty); // register notification to Qml
    viewer.rootContext()->setContextProperty("View", &viewer);
    viewer.setWindowTitle("Tweed Suit");
    // viewer.showFullScreen();

#if defined(USE_OPENGL)
    QApplication::setGraphicsSystem("opengl");
    // QGLFormat format = QGLFormat::defaultFormat();
    // format.setSampleBuffers(false);
    QGLWidget *glWidget = new QGLWidget();
    // glWidget->setAutoFillBackground(false);
    viewer.setViewport(glWidget);
#endif
    viewer.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    viewer.show();

    return app.exec();

}

