#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QStringList>
#include <QScrollArea>
#include <QTextBrowser>

class TubeApi;
class QWidget;
class QBoxLayout;
class QVBoxLayout;
class QPushButton;
class QMenu;
class QAction;
class QMaemo5ValueButton;
class QTextBrowser;
class QWebView;
class QLabel;
class QEvent;
class QPinchGesture;
class QGestureEvent;

class MainWindow : public QMainWindow 
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();
	bool event(QEvent *event);
	void pinchTriggered(QPinchGesture *gesture);
	bool gestureEvent(QGestureEvent *event);

public slots:
	void showStatusWindow();
    void showRouteWindow();
    void showMapWindow();
    void showAbout();
    void showDonate();

    void goCircle();
    void goDistrict();
    void goCentral();
    void goVictoria();
    void goHammersmithCity();
    void goJubilee();
    void goBakerloo();
    void goNorthern();
    void goWaterlooCity();
    void goPiccadilly();
    void goMetropolitan();
    void goAll();

private slots:
    void getStatusData(const QString&); // calls the tube api to get status data
    void getRouteData();  // calls the tube api to get routing data
    void formatStatusWindowData(bool);  // formats the status results in widgets
    void formatRouteWindowData(bool); // formats the routing results in widgets

	void zoomInMap();
	void zoomOutMap();

private:
    TubeApi *tubeapi1;
    TubeApi *tubeapi2;

    QTextBrowser* _scrollForStatusDataPage;
    QTextBrowser* _tubedata;
    QTextBrowser* _scrollForRouteDataPage;
    QScrollArea* _scrollForMapPage;

    QMainWindow *_mainWindow;
    QMainWindow *_dataWindow;
    QMainWindow *_routingWindow;
    QMainWindow *_routingDataWindow;
    QMainWindow *_mapWindow;

    QMenu *menu;
    QMenu *zoomMenu;
    QAction *route;
    QAction *showmap;
    QAction *aboutAct;
    QAction *donateAct;
    QAction *exitAct;

    QMenu *dataWindowMenu;
    QAction *zoomIn;
    QAction *zoomOut;
	QWidget *dataWidget;
	QVBoxLayout *dataLayout;

    QWidget *tubeListWidget;
    QBoxLayout *mainlayout;
    QVBoxLayout *sublayout1;
    QVBoxLayout *sublayout2;
    QVBoxLayout *navigationLayout;
    QPushButton *circle;
    QPushButton *district;
    QPushButton *central;
    QPushButton *victoria;
    QPushButton *hmcity;
    QPushButton *jubilee;
    QPushButton *bakerloo;
    QPushButton *northern;
    QPushButton *waterloocity;
    QPushButton *piccadilly;
    QPushButton *metropolitan;
    QPushButton *all;
	QMaemo5ValueButton *fromButton;
	QMaemo5ValueButton *toButton;
	QMaemo5ValueButton *viaButton;

	// map image
	QLabel *imageLabel;
};

#endif // MAINWINDOW_H
