# -*- coding: utf-8 -*-

#try:
#    from PyQt4.QtMaemo5 import QMaemo5InformationBox
#except ImportError:
#QMaemo5InformationBox = None
from PyQt4.QtGui import QMessageBox, QIcon

def popup_exception(e):
    QMessageBox(QMessageBox.Critical, "Error", "%s" % e, QMessageBox.Ok).exec_()

def popup_exceptions(func):
    def new_func(*args, **kwargs):
        try:
            return func(*args, **kwargs)
        except TransifexError, e:
#            if QMaemo5InformationBox:
#                QMaemo5InformationBox.information(None, \
#                    "<font color='black'>%s</font>" % e)
#            else:
            popup_exception(e)
    return new_func

class TransifexError(StandardError):
    def __init__(self, hostname="undefined"):
        self.hostname = hostname

class TransifexNeedsLogin(TransifexError):
    # Raised when GET/POST request needs authenication
    pass

class TransifexInternalServerError(TransifexError):
    # Raised when server responds with 500
    def __str__(self):
        return u"Internal error occurred on %s" % self.hostname

class TransifexLoginFailed(TransifexError):
    # Raised when login fails
    def __str__(self):
        return u"Login failed to %s" % self.hostname

class TransifexInvalidToken(TransifexError):
    # Raised when form is POSTed with incorrect CSRF token
    pass

class TransifexInvalidProfile(TransifexError):
    # Raised when /accounts/profile/ is unparsable
    pass

class TransifexInvalidResponse(TransifexError):
    def __str__(self):
        return u"Invalid response from %s" % self.hostname

class TransifexUnknownError(TransifexError):
    def __str__(self):
        return u"Unknown error occurred at %s" % self.hostname

class TransifexTimeout(TransifexError):
    # Raised when HTTP request times out
    def __str__(self):
        return u"Request to %s timed out" % self.hostname

class TransifexServerNotFound(TransifexError):
    # Raised when HTTP request fails with server not found
    def __str__(self):
        return u"Server %s not found" % self.hostname
