/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.asymmetric.ec;

import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import to_do_o.core.settings.SettingsStoreSingleton;

public class ECUtil {
    private MessageBox mb;
    private int answer;

    public ECUtil() {
    }

    public static DERObjectIdentifier getNamedCurveOid(String string) {
        DERObjectIdentifier dERObjectIdentifier = X962NamedCurves.getOID(string);
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = SECNamedCurves.getOID(string);
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = NISTNamedCurves.getOID(string);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = TeleTrusTNamedCurves.getOID(string);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = ECGOST3410NamedCurves.getOID(string);
            }
        }
        return dERObjectIdentifier;
    }

    public static X9ECParameters getNamedCurveByOid(DERObjectIdentifier dERObjectIdentifier) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(dERObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(dERObjectIdentifier);
            if (x9ECParameters == null) {
                x9ECParameters = NISTNamedCurves.getByOID(dERObjectIdentifier);
            }
            if (x9ECParameters == null) {
                x9ECParameters = TeleTrusTNamedCurves.getByOID(dERObjectIdentifier);
            }
        }
        return x9ECParameters;
    }

    public static String getCurveName(DERObjectIdentifier dERObjectIdentifier) {
        String string = X962NamedCurves.getName(dERObjectIdentifier);
        if (string == null) {
            string = SECNamedCurves.getName(dERObjectIdentifier);
            if (string == null) {
                string = NISTNamedCurves.getName(dERObjectIdentifier);
            }
            if (string == null) {
                string = TeleTrusTNamedCurves.getName(dERObjectIdentifier);
            }
            if (string == null) {
                string = ECGOST3410NamedCurves.getName(dERObjectIdentifier);
            }
        }
        return string;
    }

    public ECUtil(Shell shell, String string) {
        if (SettingsStoreSingleton.getInstance().getBoolean("ConfirmAllActions")) {
            this.mb = new MessageBox(shell, 452);
            this.mb.setText("Confirmation");
            this.mb.setMessage(string);
            this.answer = this.mb.open();
            return;
        }
        this.answer = 256;
    }

    public boolean answerYes() {
        return this.answer == 64;
    }

    public boolean answerCancel() {
        return this.answer == 256;
    }
}

