/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

public final class DERUnknownTag
extends DERObject {
    private boolean isConstructed;
    private int tag;
    private byte[] data;

    public DERUnknownTag(boolean bl, int n, byte[] byArray) {
        this.isConstructed = bl;
        this.tag = n;
        this.data = byArray;
    }

    public final int getTag() {
        return this.tag;
    }

    public final byte[] getData() {
        return this.data;
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(this.isConstructed ? 32 : 0, this.tag, this.data);
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof DERUnknownTag)) {
            return false;
        }
        object = (DERUnknownTag)object;
        return this.isConstructed == ((DERUnknownTag)object).isConstructed && this.tag == ((DERUnknownTag)object).tag && AsymmetricKeyParameter.areEqual(this.data, ((DERUnknownTag)object).data);
    }

    @Override
    public final int hashCode() {
        return (this.isConstructed ? -1 : 0) ^ this.tag ^ AsymmetricKeyParameter.hashCode(this.data);
    }
}

