/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public final class DERUniversalString
extends ASN1Object
implements DERString {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] string;

    public DERUniversalString(byte[] byArray) {
        this.string = byArray;
    }

    @Override
    public final String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        Object object = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)object);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error encoding BitString");
        }
        object = ((ByteArrayOutputStream)object).toByteArray();
        for (int i = 0; i != ((Object)object).length; ++i) {
            stringBuffer.append(table[object[i] >>> 4 & 0xF]);
            stringBuffer.append(table[object[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public final String toString() {
        return this.getString();
    }

    @Override
    final void encode(DEROutputStream object) throws IOException {
        DEROutputStream dEROutputStream = object;
        object = this;
        dEROutputStream.writeEncoded(28, ((DERUniversalString)object).string);
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)dERObject).getString());
    }

    @Override
    public final int hashCode() {
        return this.getString().hashCode();
    }
}

