/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;

public final class BERConstructedOctetString
extends DEROctetString {
    private Vector octs;

    private static byte[] toBytes(Vector vector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i != vector.size(); ++i) {
            try {
                DEROctetString dEROctetString = (DEROctetString)vector.elementAt(i);
                byteArrayOutputStream.write(dEROctetString.getOctets());
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(vector.elementAt(i).getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("exception converting octets " + iOException.toString());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BERConstructedOctetString(byte[] byArray) {
        super(byArray);
    }

    public BERConstructedOctetString(Vector vector) {
        super(BERConstructedOctetString.toBytes(vector));
        this.octs = vector;
    }

    @Override
    public final byte[] getOctets() {
        return this.string;
    }

    public final Enumeration getObjects() {
        if (this.octs == null) {
            BERConstructedOctetString bERConstructedOctetString = this;
            Vector<DEROctetString> vector = new Vector<DEROctetString>();
            for (int i = 0; i < bERConstructedOctetString.string.length; i += 1000) {
                int n = i + 1000 > bERConstructedOctetString.string.length ? bERConstructedOctetString.string.length : i + 1000;
                byte[] byArray = new byte[n - i];
                System.arraycopy(bERConstructedOctetString.string, i, byArray, 0, byArray.length);
                vector.addElement(new DEROctetString(byArray));
            }
            return vector.elements();
        }
        return this.octs.elements();
    }

    @Override
    public final void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(36);
            dEROutputStream.write(128);
            Enumeration enumeration = this.getObjects();
            while (enumeration.hasMoreElements()) {
                dEROutputStream.writeObject(enumeration.nextElement());
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
            return;
        }
        super.encode(dEROutputStream);
    }
}

