/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public abstract class ASN1Sequence
extends ASN1Object {
    private Vector seq = new Vector();

    public static ASN1Sequence getInstance(Object object) {
        if (object == null || object instanceof ASN1Sequence) {
            return (ASN1Sequence)object;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            ASN1TaggedObject aSN1TaggedObject2 = aSN1TaggedObject;
            if (!aSN1TaggedObject2.explicit) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Sequence)aSN1TaggedObject.getObject();
        }
        ASN1TaggedObject aSN1TaggedObject3 = aSN1TaggedObject;
        if (aSN1TaggedObject3.explicit) {
            if (aSN1TaggedObject instanceof BERTaggedObject) {
                return new BERSequence(aSN1TaggedObject.getObject());
            }
            return new DERSequence(aSN1TaggedObject.getObject());
        }
        if (aSN1TaggedObject.getObject() instanceof ASN1Sequence) {
            return (ASN1Sequence)aSN1TaggedObject.getObject();
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + aSN1TaggedObject.getClass().getName());
    }

    public Enumeration getObjects() {
        return this.seq.elements();
    }

    public DEREncodable getObjectAt(int n) {
        return (DEREncodable)this.seq.elementAt(n);
    }

    public int size() {
        return this.seq.size();
    }

    @Override
    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n = this.size();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            n *= 17;
            if (e == null) continue;
            n ^= e.hashCode();
        }
        return n;
    }

    @Override
    final boolean asn1Equals(DERObject object) {
        if (!(object instanceof ASN1Sequence)) {
            return false;
        }
        object = (ASN1Sequence)object;
        if (this.size() != ((ASN1Sequence)object).size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        object = ((ASN1Sequence)object).getObjects();
        while (enumeration.hasMoreElements()) {
            DERObject dERObject;
            DERObject dERObject2 = ((DEREncodable)enumeration.nextElement()).getDERObject();
            if (dERObject2 == (dERObject = ((DEREncodable)object.nextElement()).getDERObject()) || dERObject2 != null && dERObject2.equals(dERObject)) continue;
            return false;
        }
        return true;
    }

    protected void addObject(DEREncodable dEREncodable) {
        this.seq.addElement(dEREncodable);
    }

    public String toString() {
        return this.seq.toString();
    }
}

