/*
 * Decompiled with CFR 0.152.
 */
package ch.elca.el4j.services.xmlmerge.tool;

import ch.elca.el4j.services.xmlmerge.XmlMerge;
import ch.elca.el4j.services.xmlmerge.config.ConfigurableXmlMerge;
import ch.elca.el4j.services.xmlmerge.config.PropertyXPathConfigurer;
import ch.elca.el4j.services.xmlmerge.merge.DefaultXmlMerge;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class XmlMergeTool {
    protected XmlMergeTool() {
    }

    public static void main(String[] args) throws Exception {
        XmlMerge xmlMerge;
        if (args.length < 2) {
            XmlMergeTool.usage();
        }
        int argCursor = 0;
        String configFilename = null;
        if ("-config".equals(args[0])) {
            if (args[1] != null) {
                configFilename = args[1];
            }
            argCursor = 2;
            if (args.length < 4) {
                XmlMergeTool.usage();
            }
        }
        if (configFilename != null) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(configFilename));
            }
            catch (FileNotFoundException ex) {
                System.err.println("File not found: " + configFilename);
                System.exit(1);
            }
            catch (IOException ioe) {
                System.err.println("Cannot read file: " + configFilename);
                System.exit(1);
            }
            xmlMerge = new ConfigurableXmlMerge(new DefaultXmlMerge(), new PropertyXPathConfigurer(props));
        } else {
            xmlMerge = new DefaultXmlMerge();
        }
        InputStream[] sources = new InputStream[args.length - argCursor];
        for (int i = argCursor; i < args.length; ++i) {
            String filename = args[i];
            try {
                sources[i - argCursor] = new FileInputStream(filename);
                continue;
            }
            catch (FileNotFoundException ex) {
                System.err.println("File not found: " + filename);
                System.exit(1);
            }
        }
        InputStream stream = xmlMerge.merge(sources);
        byte[] buffer = new byte[2048];
        try {
            int len;
            while ((len = stream.read(buffer)) != -1) {
                System.out.write(buffer, 0, len);
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void usage() {
        System.err.println("xmlmerge [-config <config-file>] file1 file2 [file3 ...]");
        System.exit(1);
    }
}

