/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.misc.NetscapeCertType;
import org.bouncycastle.asn1.misc.NetscapeRevocationURL;
import org.bouncycastle.asn1.misc.VerisignCzagExtension;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.JDKKeyFactory;
import org.bouncycastle.jce.provider.PKCS12BagAttributeCarrierImpl;
import org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import org.bouncycastle.jce.provider.X509SignatureUtil;
import org.bouncycastle.util.encoders.Hex;

public final class X509CertificateObject
extends X509Certificate
implements CipherParameters {
    private X509CertificateStructure c;
    private BasicConstraints basicConstraints;
    private boolean[] keyUsage;
    private boolean hashValueSet;
    private int hashValue;

    public X509CertificateObject(X509CertificateStructure object) throws CertificateParsingException {
        block7: {
            new PKCS12BagAttributeCarrierImpl();
            this.c = object;
            try {
                byte[] byArray = this.getExtensionBytes("2.5.29.19");
                object = byArray;
                if (byArray != null) {
                    this.basicConstraints = BasicConstraints.getInstance(ASN1Object.fromByteArray((byte[])object));
                }
            }
            catch (Exception exception) {
                throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
            }
            try {
                byte[] byArray = this.getExtensionBytes("2.5.29.15");
                object = byArray;
                if (byArray != null) {
                    DERBitString dERBitString = DERBitString.getInstance(ASN1Object.fromByteArray((byte[])object));
                    byte[] byArray2 = dERBitString.getBytes();
                    object = byArray2;
                    int n = (byArray2.length << 3) - dERBitString.getPadBits();
                    this.keyUsage = new boolean[n < 9 ? 9 : n];
                    for (int i = 0; i != n; ++i) {
                        this.keyUsage[i] = (object[i / 8] & 128 >>> i % 8) != 0;
                    }
                    break block7;
                }
                this.keyUsage = null;
                return;
            }
            catch (Exception exception) {
                throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
            }
        }
    }

    @Override
    public final void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public final void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.c.getEndDate().getTime());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.c.getStartDate().getTime());
        }
    }

    @Override
    public final int getVersion() {
        return this.c.getVersion();
    }

    @Override
    public final BigInteger getSerialNumber() {
        return this.c.getSerialNumber().getValue();
    }

    @Override
    public final Principal getIssuerDN() {
        return new X509Principal(this.c.getIssuer());
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.c.getIssuer());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public final Principal getSubjectDN() {
        return new X509Principal(this.c.getSubject());
    }

    @Override
    public final X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.c.getSubject());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public final Date getNotBefore() {
        return this.c.getStartDate().getDate();
    }

    @Override
    public final Date getNotAfter() {
        return this.c.getEndDate().getDate();
    }

    @Override
    public final byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.c.getTBSCertificate().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public final byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    @Override
    public final String getSigAlgName() {
        Object object = Security.getProvider("BC");
        if (object != null && (object = object.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i = 0; i != ((Provider[])object).length; ++i) {
            String string = object[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    @Override
    public final String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getObjectId().getId();
    }

    @Override
    public final byte[] getSigAlgParams() {
        if (this.c.getSignatureAlgorithm().getParameters() != null) {
            return this.c.getSignatureAlgorithm().getParameters().getDERObject().getDEREncoded();
        }
        return null;
    }

    @Override
    public final boolean[] getIssuerUniqueID() {
        Object object = this.c.getTBSCertificate().getIssuerUniqueId();
        if (object != null) {
            byte[] byArray = ((DERBitString)object).getBytes();
            object = new boolean[(byArray.length << 3) - ((DERBitString)object).getPadBits()];
            for (int i = 0; i != ((Object)object).length; ++i) {
                object[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return object;
        }
        return null;
    }

    @Override
    public final boolean[] getSubjectUniqueID() {
        Object object = this.c.getTBSCertificate().getSubjectUniqueId();
        if (object != null) {
            byte[] byArray = ((DERBitString)object).getBytes();
            object = new boolean[(byArray.length << 3) - ((DERBitString)object).getPadBits()];
            for (int i = 0; i != ((Object)object).length; ++i) {
                object[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return object;
        }
        return null;
    }

    @Override
    public final boolean[] getKeyUsage() {
        return this.keyUsage;
    }

    public final List getExtendedKeyUsage() throws CertificateParsingException {
        Object object = this.getExtensionBytes("2.5.29.37");
        if (object != null) {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream((byte[])object);
                object = aSN1InputStream;
                object = (ASN1Sequence)aSN1InputStream.readObject();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i != object.size(); ++i) {
                    arrayList.add(((DERObjectIdentifier)object.getObjectAt(i)).getId());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    @Override
    public final int getBasicConstraints() {
        if (this.basicConstraints != null) {
            if (this.basicConstraints.isCA()) {
                if (this.basicConstraints.getPathLenConstraint() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.basicConstraints.getPathLenConstraint().intValue();
            }
            return -1;
        }
        return -1;
    }

    public final Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
            if (x509Extensions != null) {
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                    if (!x509Extension.isCritical()) continue;
                    hashSet.add(dERObjectIdentifier.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] getExtensionBytes(String object) {
        X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
        if (x509Extensions != null && (object = x509Extensions.getExtension(new DERObjectIdentifier((String)object))) != null) {
            return ((X509Extension)object).getValue().getOctets();
        }
        return null;
    }

    @Override
    public final byte[] getExtensionValue(String object) {
        X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
        if (x509Extensions != null && (object = x509Extensions.getExtension(new DERObjectIdentifier((String)object))) != null) {
            try {
                return ((X509Extension)object).getValue().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public final Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
            if (x509Extensions != null) {
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                    if (x509Extension.isCritical()) continue;
                    hashSet.add(dERObjectIdentifier.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        X509Extensions x509Extensions;
        if (this.getVersion() == 3 && (x509Extensions = this.c.getTBSCertificate().getExtensions()) != null) {
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                Object object = (DERObjectIdentifier)enumeration.nextElement();
                String string = ((DERObjectIdentifier)object).getId();
                if (string.equals(RFC3280CertPathUtilities.KEY_USAGE) || string.equals(RFC3280CertPathUtilities.CERTIFICATE_POLICIES) || string.equals(RFC3280CertPathUtilities.POLICY_MAPPINGS) || string.equals(RFC3280CertPathUtilities.INHIBIT_ANY_POLICY) || string.equals(RFC3280CertPathUtilities.CRL_DISTRIBUTION_POINTS) || string.equals(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT) || string.equals(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR) || string.equals(RFC3280CertPathUtilities.POLICY_CONSTRAINTS) || string.equals(RFC3280CertPathUtilities.BASIC_CONSTRAINTS) || string.equals(RFC3280CertPathUtilities.SUBJECT_ALTERNATIVE_NAME) || string.equals(RFC3280CertPathUtilities.NAME_CONSTRAINTS) || !((X509Extension)(object = x509Extensions.getExtension((DERObjectIdentifier)object))).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final PublicKey getPublicKey() {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(this.c.getSubjectPublicKeyInfo());
    }

    @Override
    public final byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.c.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Certificate)) {
            return false;
        }
        object = (Certificate)object;
        try {
            byte[] byArray = this.getEncoded();
            object = ((Certificate)object).getEncoded();
            return PKCS1Encoding.areEqual(byArray, (byte[])object);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    @Override
    public final synchronized int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = this.calculateHashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    private int calculateHashCode() {
        try {
            return PKCS1Encoding.hashCode(this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return 0;
        }
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        Object object = this.getSignature();
        stringBuffer.append("            Signature: ").append(new String(Hex.encode((byte[])object, 0, 20))).append(string);
        for (int i = 20; i < ((byte[])object).length; i += 20) {
            if (i < ((byte[])object).length - 20) {
                stringBuffer.append("                       ").append(new String(Hex.encode((byte[])object, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(new String(Hex.encode((byte[])object, i, ((byte[])object).length - i))).append(string);
        }
        X509Extensions x509Extensions = this.c.getTBSCertificate().getExtensions();
        if (x509Extensions != null) {
            Enumeration enumeration = x509Extensions.oids();
            object = enumeration;
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (object.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)object.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (x509Extension.getValue() != null) {
                    Object object2 = x509Extension.getValue().getOctets();
                    object2 = new ASN1InputStream((byte[])object2);
                    stringBuffer.append("                       critical(").append(x509Extension.isCritical()).append(") ");
                    try {
                        if (dERObjectIdentifier.equals(X509Extensions.BasicConstraints)) {
                            stringBuffer.append(new BasicConstraints((ASN1Sequence)((ASN1InputStream)object2).readObject())).append(string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(X509Extensions.KeyUsage)) {
                            stringBuffer.append(new KeyUsage((DERBitString)((ASN1InputStream)object2).readObject())).append(string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.netscapeCertType)) {
                            stringBuffer.append(new NetscapeCertType((DERBitString)((ASN1InputStream)object2).readObject())).append(string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.netscapeRevocationURL)) {
                            stringBuffer.append(new NetscapeRevocationURL((DERIA5String)((ASN1InputStream)object2).readObject())).append(string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.verisignCzagExtension)) {
                            stringBuffer.append(new VerisignCzagExtension((DERIA5String)((ASN1InputStream)object2).readObject())).append(string);
                            continue;
                        }
                        stringBuffer.append(dERObjectIdentifier.getId());
                        stringBuffer.append(" value = ").append(ASN1Dump.dumpAsString(((ASN1InputStream)object2).readObject())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(dERObjectIdentifier.getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        String string = X509SignatureUtil.getSignatureName(this.c.getSignatureAlgorithm());
        try {
            signature = Signature.getInstance(string, "BC");
        }
        catch (Exception exception) {
            signature = Signature.getInstance(string);
        }
        this.checkSignature(publicKey, signature);
    }

    @Override
    public final void verify(PublicKey publicKey, String object) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = X509SignatureUtil.getSignatureName(this.c.getSignatureAlgorithm());
        object = Signature.getInstance(string, (String)object);
        this.checkSignature(publicKey, (Signature)object);
    }

    private void checkSignature(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertificate().getSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        DEREncodable dEREncodable = this.c.getSignatureAlgorithm().getParameters();
        X509SignatureUtil.setSignatureParameters(signature, dEREncodable);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }
}

